/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.validators;

import com.jaspersoft.jasperserver.api.security.validators.ValidatorRule;
import com.jaspersoft.jasperserver.api.security.validators.ValidatorRuleException;

public class ValidatorRuleImpl
implements ValidatorRule {
    private String paramValidationKey;
    private String valueValidationKey;
    private int maxLength;
    private boolean allowNull;
    private String context;
    private boolean isBlacklistRule = false;

    public ValidatorRuleImpl(String paramValidationKey, String valueValidationKey, int maxLength, boolean allowNull, String context) {
        if (valueValidationKey != null && valueValidationKey != null && maxLength > 0 && context != null) {
            this.paramValidationKey = paramValidationKey;
            this.valueValidationKey = valueValidationKey;
            if (valueValidationKey.startsWith("!")) {
                this.isBlacklistRule = true;
                this.valueValidationKey = valueValidationKey.substring(1);
            }
        } else {
            throw new ValidatorRuleException();
        }
        this.maxLength = maxLength;
        this.allowNull = allowNull;
        this.context = context;
    }

    public ValidatorRuleImpl(ValidatorRule rule) {
        this(rule.getParamValidationKey(), rule.getValueValidationKey(), rule.getMaxLength(), rule.isAllowNull(), rule.getContext());
        this.isBlacklistRule = rule.isBlacklistRule();
    }

    @Override
    public String getParamValidationKey() {
        return this.paramValidationKey;
    }

    @Override
    public String getValueValidationKey() {
        return this.valueValidationKey;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public boolean isBlacklistRule() {
        return this.isBlacklistRule;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String SPACER = "][";
        sb.append("[" + this.paramValidationKey).append(SPACER);
        sb.append(this.valueValidationKey).append(SPACER);
        sb.append(this.maxLength).append(SPACER);
        sb.append(this.allowNull).append(SPACER);
        sb.append(this.context).append(SPACER);
        sb.append(this.isBlacklistRule ? "blacklist" : "whitelist").append("]");
        return sb.toString();
    }
}

