/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityEventListener;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityEventListenerRegistry;
import java.util.ArrayList;
import java.util.List;

public class HibernateUserAuthorityDeleteListener
implements HibernateDeleteListener,
UserAuthorityEventListenerRegistry {
    private List listeners;

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    protected void ensureListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public void registerListener(UserAuthorityEventListener listener) {
        this.ensureListeners();
        this.listeners.add(listener);
    }

    public void deregisterListener(UserAuthorityEventListener listener) {
        this.ensureListeners();
        this.listeners.remove(listener);
    }

    @Override
    public void onDelete(Object o) {
        if (o instanceof RepoUser) {
            RepoUser user = (RepoUser)o;
            final String username = user.getUsername();
            this.fireListeners(new ListenerVisitor(){

                @Override
                public void visit(UserAuthorityEventListener listener) {
                    listener.onUserDelete(username);
                }
            });
        } else if (o instanceof RepoRole) {
            RepoRole role = (RepoRole)o;
            final String roleName = role.getRoleName();
            this.fireListeners(new ListenerVisitor(){

                @Override
                public void visit(UserAuthorityEventListener listener) {
                    listener.onRoleDelete(roleName);
                }
            });
        }
    }

    protected void fireListeners(ListenerVisitor visitor) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (UserAuthorityEventListener listener : this.listeners) {
                visitor.visit(listener);
            }
        }
    }

    protected static interface ListenerVisitor {
        public void visit(UserAuthorityEventListener var1);
    }
}

