/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import java.io.Serializable;
import org.springframework.security.GrantedAuthority;

public class TenantAwareGrantedAuthority
implements GrantedAuthority,
TenantQualified,
Serializable {
    private String authority;
    private String tenantId;

    public TenantAwareGrantedAuthority(String authority, String tenantId) {
        this.authority = authority;
        this.tenantId = tenantId;
    }

    public TenantAwareGrantedAuthority(Role role) {
        this.authority = role.getRoleName();
        this.tenantId = role.getTenantId() == "organizations" ? null : role.getTenantId();
    }

    public TenantAwareGrantedAuthority(String authority) {
        this(authority, null);
    }

    public String getAuthority() {
        return this.tenantId == null ? this.authority : this.authority + "|" + this.tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return obj.equals(this.authority);
        }
        if (obj instanceof GrantedAuthority && !(obj instanceof TenantQualified)) {
            return ((GrantedAuthority)obj).getAuthority().equals(this.authority);
        }
        if (obj instanceof GrantedAuthority && obj instanceof TenantQualified) {
            String authority = ((GrantedAuthority)obj).getAuthority();
            String tenantId = ((TenantQualified)obj).getTenantId();
            return authority.equals(this.authority) && (tenantId == null ? this.tenantId == null : tenantId.equals(this.tenantId));
        }
        return false;
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

