/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockKey;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalLockManager
implements LockManager {
    private static final Log log = LogFactory.getLog(LocalLockManager.class);
    private Set locks = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockHandle lock(String lockName, String key) {
        Pair lockKey = this.getLockKey(lockName, key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Acquiring lock for " + lockKey));
        }
        Set set = this.locks;
        synchronized (set) {
            while (this.locks.contains(lockKey)) {
                try {
                    this.locks.wait();
                }
                catch (InterruptedException e) {
                    throw new JSExceptionWrapper((Exception)e);
                }
            }
            this.locks.add(lockKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquired lock for " + lockKey));
            }
        }
        return new LockKey(lockKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(LockHandle lock) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Releasing lock for " + lock.getLockKey()));
        }
        Set set = this.locks;
        synchronized (set) {
            this.locks.remove(lock.getLockKey());
            this.locks.notifyAll();
        }
    }

    protected Pair getLockKey(String lockName, String key) {
        return new Pair((Object)lockName, (Object)key);
    }
}

