/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.properties.DecryptingPropertyPlaceholderConfigurer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class JndiFallbackResolver
implements Serializable {
    public static final String JDBC_DRIVER_CLASS_NAME = "driverClassName";
    public static final String JDBC_URL = "url";
    public static final String JDBC_USERNAME = "username";
    public static final String JDBC_PASSWORD = "password";

    public Map<String, String> getJdbcPropertiesMap(String jndiName) {
        Map springProps = DecryptingPropertyPlaceholderConfigurer.getSpringImportedProperties();
        if (springProps == null) {
            throw new JSException("No JNDI fallback properties available.");
        }
        String propPrefix = null;
        for (Map.Entry entry : springProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(".jndi") || !((String)entry.getValue()).equals(jndiName)) continue;
            propPrefix = key.replace(".jndi", "");
            break;
        }
        if (propPrefix == null) {
            throw new JSException("No matching JNDI property found for '" + jndiName + "' in fallback properties.");
        }
        HashMap<String, String> jdbcPropertiesMap = new HashMap<String, String>(4);
        jdbcPropertiesMap.put(JDBC_DRIVER_CLASS_NAME, this.getFallbackProperty(propPrefix, JDBC_DRIVER_CLASS_NAME));
        jdbcPropertiesMap.put(JDBC_URL, StringEscapeUtils.unescapeXml((String)this.getFallbackProperty(propPrefix, JDBC_URL)));
        jdbcPropertiesMap.put(JDBC_USERNAME, this.getFallbackProperty(propPrefix, JDBC_USERNAME));
        jdbcPropertiesMap.put(JDBC_PASSWORD, this.getFallbackProperty(propPrefix, JDBC_PASSWORD));
        return jdbcPropertiesMap;
    }

    private String getFallbackProperty(String prefix, String suffix) {
        Map springProps = DecryptingPropertyPlaceholderConfigurer.getSpringImportedProperties();
        String value = (String)springProps.get(prefix + ".jdbc." + suffix);
        if (value == null) {
            throw new JSException("No value for '" + suffix + "' in fallback properties.");
        }
        return value;
    }
}

