/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceBase;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class SortingUtils {
    public static void sortFoldersByName(Collator collator, List folders) {
        ListIterator<FolderNameCollationKey> it = folders.listIterator();
        while (it.hasNext()) {
            Folder folder = (Folder)it.next();
            it.set(new FolderNameCollationKey(collator, folder));
        }
        Collections.sort(folders);
        it = folders.listIterator();
        while (it.hasNext()) {
            FolderNameCollationKey folderKey = (FolderNameCollationKey)it.next();
            it.set((FolderNameCollationKey)folderKey.folder);
        }
    }

    public static void sortFoldersByURI(Collator collator, List folders) {
        ListIterator<FolderURICollationKey> it = folders.listIterator();
        while (it.hasNext()) {
            Folder folder = (Folder)it.next();
            it.set(new FolderURICollationKey(collator, folder));
        }
        Collections.sort(folders);
        it = folders.listIterator();
        while (it.hasNext()) {
            FolderURICollationKey folderKey = (FolderURICollationKey)it.next();
            it.set((FolderURICollationKey)folderKey.folder);
        }
    }

    public static void sortRepoResourcesByURI(Collator collator, List resources) {
        ListIterator<Object> it = resources.listIterator();
        while (it.hasNext()) {
            Object ojb = it.next();
            if (!(ojb instanceof RepoResourceBase)) continue;
            RepoResourceBase resource = (RepoResourceBase)ojb;
            it.set(new RepoResourceURICollationKey(collator, resource));
        }
        Collections.sort(resources);
        it = resources.listIterator();
        while (it.hasNext()) {
            RepoResourceURICollationKey resourceKey = (RepoResourceURICollationKey)it.next();
            it.set(resourceKey.resource);
        }
    }

    protected static class RepoResourceURICollationKey
    extends CollationKeyDecorator {
        protected final RepoResourceBase resource;

        public RepoResourceURICollationKey(Collator collator, RepoResourceBase resource) {
            super(collator, resource.getResourceURI());
            this.resource = resource;
        }
    }

    protected static class FolderURICollationKey
    extends CollationKeyDecorator {
        protected final Folder folder;

        public FolderURICollationKey(Collator collator, Folder folder) {
            super(collator, folder.getURIString());
            this.folder = folder;
        }
    }

    protected static class FolderNameCollationKey
    extends CollationKeyDecorator {
        protected final Folder folder;

        public FolderNameCollationKey(Collator collator, Folder folder) {
            super(collator, folder.getName());
            this.folder = folder;
        }
    }

    protected static abstract class CollationKeyDecorator
    implements Comparable {
        private final CollationKey key;

        protected CollationKeyDecorator(Collator collator, String value) {
            this.key = collator.getCollationKey(value);
        }

        public int compareTo(Object o) {
            return this.key.compareTo(((CollationKeyDecorator)o).key);
        }
    }
}

