/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.Cipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordEncryptionException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.providers.encoding.PasswordEncoder;

public class PasswordValidator
implements PasswordEncoder {
    private static final Logger log = LogManager.getLogger(PasswordValidator.class);
    private static Cipherer cipherer;
    private boolean keyInPlainText;
    private String secretKey;
    private String secretKeyAlgorithm;
    private String cipherTransformation;

    protected PasswordValidator() {
        if (cipherer == null) {
            cipherer = new Cipherer();
            if (this.secretKey != null) {
                cipherer.setKeyBytes(this.secretKey, this.keyInPlainText);
            }
            if (this.cipherTransformation != null) {
                cipherer.setCipherTransformation(this.cipherTransformation);
            }
            if (this.secretKeyAlgorithm != null) {
                cipherer.setKeyAlgorithm(this.secretKeyAlgorithm);
            }
            cipherer.init();
        }
    }

    private String encodePassword(String rawPass) throws DataAccessException {
        try {
            return cipherer.encode(rawPass);
        }
        catch (Exception ex) {
            log.debug((Object)ex);
            throw new PasswordEncryptionException(ex.getMessage(), ex.getCause());
        }
    }

    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return this.encodePassword(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        String pass1 = "" + encPass;
        String pass2 = this.encodePassword(rawPass);
        return pass1.equals(pass2);
    }

    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public void setCipherTransformation(String cipherTransformation) {
        this.cipherTransformation = cipherTransformation;
    }

    public boolean isKeyInPlainText() {
        return this.keyInPlainText;
    }

    public void setKeyInPlainText(boolean keyInPlainText) {
        this.keyInPlainText = keyInPlainText;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }
}

