/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceBase;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DriverDeleteListener
implements PostDeleteEventListener,
ApplicationContextAware {
    protected ApplicationContext context;
    protected String propertiesManagementServiceName;
    protected PropertiesManagementService propertiesManagementService;
    private String jdbcDriversFolder;

    public String getPropertiesManagementServiceName() {
        return this.propertiesManagementServiceName;
    }

    public void setPropertiesManagementServiceName(String propertiesManagementServiceName) {
        this.propertiesManagementServiceName = propertiesManagementServiceName;
    }

    public String getJdbcDriversFolder() {
        return this.jdbcDriversFolder;
    }

    public void setJdbcDriversFolder(String jdbcDriversFolder) {
        this.jdbcDriversFolder = jdbcDriversFolder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void onPostDelete(PostDeleteEvent event) {
        RepoResourceBase file;
        RepoFolder parent;
        if (this.propertiesManagementServiceName == null) {
            return;
        }
        Object entity = event.getEntity();
        if ((entity instanceof RepoFileResource || entity instanceof RepoFolder) && (parent = (file = (RepoResourceBase)entity).getParent()) != null) {
            if (parent.getResourceURI().equals(this.jdbcDriversFolder)) {
                this.getService().removeByValue(file.getName());
            } else {
                RepoFolder parentOfParent = parent.getParent();
                if (parentOfParent != null && parentOfParent.getResourceURI().equals(this.jdbcDriversFolder) && parent.getChildren().size() == 0) {
                    this.getService().removeByValue(parent.getName());
                }
            }
        }
    }

    private PropertiesManagementService getService() {
        if (this.propertiesManagementService == null) {
            this.propertiesManagementService = (PropertiesManagementService)this.context.getBean(this.propertiesManagementServiceName, PropertiesManagementService.class);
        }
        return this.propertiesManagementService;
    }
}

