/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class RepositoryDiagnosticService
implements Diagnostic {
    private DataSource dataSource;
    private Map<String, String> metaDataMap;

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        if (this.metaDataMap == null) {
            this.fillMetaDataMap();
        }
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("DatabaseProductName", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("DatabaseProductName");
            }
        }).addDiagnosticAttribute("DatabaseProductVersion", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("DatabaseProductVersion");
            }
        }).addDiagnosticAttribute("DriverName", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("DriverName");
            }
        }).addDiagnosticAttribute("SQLKeywords", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("SQLKeywords");
            }
        }).addDiagnosticAttribute("URL", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("URL");
            }
        }).addDiagnosticAttribute("UserName", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("UserName");
            }
        }).addDiagnosticAttribute("JDBCMajorVersion", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("JDBCMajorVersion");
            }
        }).addDiagnosticAttribute("JDBCMinorVersion", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("JDBCMinorVersion");
            }
        }).addDiagnosticAttribute("MaxRowSize", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxRowSize");
            }
        }).addDiagnosticAttribute("MaxStatementLength", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxStatementLength");
            }
        }).addDiagnosticAttribute("MaxConnections", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxConnections");
            }
        }).addDiagnosticAttribute("MaxCharLiteralLength", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxCharLiteralLength");
            }
        }).addDiagnosticAttribute("MaxColumnsInTable", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxColumnsInTable");
            }
        }).addDiagnosticAttribute("MaxColumnsInSelect", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxColumnsInSelect");
            }
        }).addDiagnosticAttribute("MaxColumnsInGroupBy", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxColumnsInGroupBy");
            }
        }).addDiagnosticAttribute("MaxColumnNameLength", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return (String)RepositoryDiagnosticService.this.metaDataMap.get("MaxColumnNameLength");
            }
        }).build();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void fillMetaDataMap() {
        this.metaDataMap = new HashMap<String, String>();
        try {
            DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
            this.metaDataMap.put("DatabaseProductName", metaData.getDatabaseProductName());
            this.metaDataMap.put("DatabaseProductVersion", metaData.getDatabaseProductVersion());
            this.metaDataMap.put("DriverName", metaData.getDriverName());
            this.metaDataMap.put("SQLKeywords", metaData.getSQLKeywords());
            this.metaDataMap.put("URL", metaData.getURL());
            this.metaDataMap.put("UserName", metaData.getUserName());
            this.metaDataMap.put("JDBCMajorVersion", String.valueOf(metaData.getJDBCMajorVersion()));
            this.metaDataMap.put("JDBCMinorVersion", String.valueOf(metaData.getJDBCMinorVersion()));
            this.metaDataMap.put("MaxRowSize", String.valueOf(metaData.getMaxRowSize()));
            this.metaDataMap.put("MaxStatementLength", String.valueOf(metaData.getMaxStatementLength()));
            this.metaDataMap.put("MaxConnections", String.valueOf(metaData.getMaxConnections()));
            this.metaDataMap.put("MaxCharLiteralLength", String.valueOf(metaData.getMaxCharLiteralLength()));
            this.metaDataMap.put("MaxColumnsInTable", String.valueOf(metaData.getMaxColumnsInTable()));
            this.metaDataMap.put("MaxColumnsInSelect", String.valueOf(metaData.getMaxColumnsInSelect()));
            this.metaDataMap.put("MaxColumnsInGroupBy", String.valueOf(metaData.getMaxColumnsInGroupBy()));
            this.metaDataMap.put("MaxColumnNameLength", String.valueOf(metaData.getMaxColumnNameLength()));
            metaData.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

