/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.jmx;

import java.util.List;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;

public class JmxSecurityAuthenticator
implements JMXAuthenticator {
    private AuthenticationManager authenticationManager;
    private List<String> allowedRoles;
    private static final String UNAUTHORIZED = "Unauthorized";

    @Override
    public Subject authenticate(Object credentials) {
        try {
            String[] info = (String[])credentials;
            Authentication auth = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)info[0], (Object)info[1]));
            SecurityContextHolder.getContext().setAuthentication(auth);
            Subject s = new Subject();
            if (!auth.isAuthenticated()) {
                throw new SecurityException(UNAUTHORIZED);
            }
            if (auth.getPrincipal() instanceof UserDetails) {
                UserDetails contextUserDetails = (UserDetails)auth.getPrincipal();
                for (GrantedAuthority authority : contextUserDetails.getAuthorities()) {
                    if (!this.allowedRoles.contains(authority.getAuthority())) continue;
                    s.getPrincipals().add(new JMXPrincipal(auth.getName()));
                    return s;
                }
                throw new SecurityException(UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        return null;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAllowedRoles(List<String> allowedRoles) {
        this.allowedRoles = allowedRoles;
    }
}

