/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.context.impl;

import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LoggingContextImpl
implements LoggingContext {
    private List<LoggableEvent> events = new ArrayList<LoggableEvent>();
    private Map<Class<? extends LoggableEvent>, Boolean> enabledLoggingTypesMap;

    public void setEnabledLoggingTypesMap(Map<Class<? extends LoggableEvent>, Boolean> enabledLoggingTypesMap) {
        this.enabledLoggingTypesMap = enabledLoggingTypesMap;
    }

    private boolean isLogEnabled(LoggableEvent loggableEvent) {
        boolean isEnabled = false;
        for (Class<? extends LoggableEvent> clazz : this.enabledLoggingTypesMap.keySet()) {
            if (!clazz.isAssignableFrom(loggableEvent.getClass())) continue;
            isEnabled = true;
            break;
        }
        return isEnabled;
    }

    public void logEvent(LoggableEvent loggableEvent) {
        if (loggableEvent != null && this.isLogEnabled(loggableEvent)) {
            this.events.add(loggableEvent);
        }
    }

    public List<LoggableEvent> getAllEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void removeEvents(List<LoggableEvent> events) {
        for (LoggableEvent event : events) {
            this.events.remove(event);
        }
    }

    public void clearAllEvents() {
        this.events.clear();
    }
}

