/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.access.context.impl;

import com.jaspersoft.jasperserver.api.logging.access.context.AccessContext;
import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContextProvider;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.util.Date;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;

public class AccessContextImpl
implements AccessContext {
    private LoggingContextProvider loggingContextProvider;
    private ResourceFactory clientClassFactory;
    private UserAuthorityService userAuthorityService;

    public void setLoggingContextProvider(LoggingContextProvider loggingContextProvider) {
        this.loggingContextProvider = loggingContextProvider;
    }

    public void setClientClassFactory(ResourceFactory clientClassFactory) {
        this.clientClassFactory = clientClassFactory;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    protected String getContextUsername() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return null;
        }
        if (authenticationToken.getPrincipal() instanceof UserDetails) {
            UserDetails contextUserDetails = (UserDetails)authenticationToken.getPrincipal();
            return contextUserDetails.getUsername();
        }
        if (authenticationToken.getPrincipal() instanceof String) {
            return (String)authenticationToken.getPrincipal();
        }
        return null;
    }

    protected User getUserFromSecurityContext() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return null;
        }
        if (authenticationToken.getPrincipal() instanceof User) {
            return (User)authenticationToken.getPrincipal();
        }
        return null;
    }

    protected User getContextUser() {
        User user = this.getUserFromSecurityContext();
        if (user == null) {
            String username = this.getContextUsername();
            if (username == null) {
                return null;
            }
            user = this.userAuthorityService.getUser(null, username);
        }
        return user;
    }

    public void doInAccessContext(AccessContext.AccessContextCallback callback) {
        User user;
        if (this.loggingContextProvider.isLoggingEnabled(AccessEvent.class) && callback != null && (user = this.getContextUser()) != null) {
            AccessEvent accessEvent = (AccessEvent)this.clientClassFactory.newObject(AccessEvent.class);
            accessEvent.setEventDate(new Date());
            accessEvent.setUser(user);
            callback.fillAccessEvent(accessEvent);
            this.loggingContextProvider.getContext().logEvent((LoggableEvent)accessEvent);
        }
    }
}

