/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.replication.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JGroupsInputStream
extends InputStream {
    private long timeout = 15000L;
    private volatile byte[] buf;
    private volatile int index = 0;
    private ReentrantLock lock = new ReentrantLock();
    private Condition write = this.lock.newCondition();
    private Condition doneReading = this.lock.newCondition();

    public JGroupsInputStream(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.index < 0) {
            return -1;
        }
        if (this.buf == null) {
            this.lock.lock();
            try {
                long waitTime = TimeUnit.MILLISECONDS.toNanos(this.timeout);
                while (this.buf == null) {
                    if ((waitTime = this.write.awaitNanos(waitTime)) > 0L) continue;
                    throw new IOException(new TimeoutException());
                }
                if (this.index < 0) {
                    int n = -1;
                    return n;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.index == this.buf.length) {
            this.lock.lock();
            try {
                this.buf = null;
                this.index = 0;
                this.doneReading.signal();
            }
            finally {
                this.lock.unlock();
            }
            return this.read();
        }
        return this.buf[this.index++] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            this.buf = null;
            this.index = -1;
            this.doneReading.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(byte[] bytes) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.index == -1) {
                return;
            }
            while (this.buf != null) {
                this.doneReading.await();
            }
            if (this.index == -1) {
                return;
            }
            this.buf = bytes;
            if (bytes == null) {
                this.index = -1;
            }
            this.write.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

