/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.vfs.VirtualFile;
import org.teiid.core.index.IDocument;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.index.IIndex;
import org.teiid.core.index.IIndexer;
import org.teiid.core.index.IQueryResult;
import org.teiid.internal.core.index.BlocksIndexInput;
import org.teiid.internal.core.index.BlocksIndexOutput;
import org.teiid.internal.core.index.InMemoryIndex;
import org.teiid.internal.core.index.IndexInput;
import org.teiid.internal.core.index.IndexedFile;
import org.teiid.internal.core.index.IndexerOutput;
import org.teiid.internal.core.index.SimpleIndexInput;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private VirtualFile indexFile;
    private BlocksIndexInput cachedInput;
    protected boolean doCache = false;
    private String resourceFileName;
    public String toString;

    public Index(VirtualFile f, boolean reuseExistingFile) throws IOException {
        this.indexFile = f;
        this.initialize(reuseExistingFile);
    }

    @Override
    public void add(IDocument document, IIndexer indexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(document.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(document, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    @Override
    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    @Override
    public VirtualFile getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumDocuments() throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            input.open();
            int n = input.getNumFiles();
            return n;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumWords() throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            input.open();
            int n = input.getNumWords();
            return n;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPath(int documentNumber) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            input.open();
            IndexedFile file = input.getIndexedFile(documentNumber);
            if (file == null) {
                String string = null;
                return string;
            }
            String string = file.getPath();
            return string;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.canMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists() && this.indexFile.getSize() > 0L) {
            BlocksIndexInput mainIndexInput = this.getBlocksIndexInput();
            try {
                mainIndexInput.open();
            }
            catch (IOException e) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.setOpen(true);
                    input.close();
                }
                finally {
                    input.setOpen(false);
                }
                this.indexFile.delete();
                mainIndexInput = null;
                throw e;
            }
            if (!this.doCache) {
                mainIndexInput.close();
            }
        } else {
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            mainIndex.save(mainIndexOutput);
        }
    }

    protected void merge() throws IOException {
        throw new IOException("Can not merge the Index files. These are read only files for Teiid purpose.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] query(String word) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.query(word);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesPrefixedBy(prefix);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.queryInDocumentNames(word);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.queryFilesReferringToPrefix(prefix);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntriesMatching(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesMatching(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntries(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesPrefixedBy(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    @Override
    public void remove(String documentName) throws IOException {
        IndexedFile file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            int[] lastRemoved = (int[])this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileNumber();
                if (lastRemoved[0] < fileNum) {
                    lastRemoved[0] = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new int[]{file.getFileNumber()});
            }
        } else {
            this.removedInOld.put(documentName, new int[]{1});
        }
        this.state = 0;
    }

    protected void remove(IndexedFile file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            int[] lastRemoved = (int[])this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved[0] < file.getFileNumber()) {
                    lastRemoved[0] = file.getFileNumber();
                }
            } else {
                this.removedInAdds.put(name, new int[]{file.getFileNumber()});
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new int[]{1});
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    @Override
    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BlocksIndexInput getBlocksIndexInput() {
        if (!this.doCache) return new BlocksIndexInput(this.indexFile);
        if (this.getCachedInput() != null) return this.getCachedInput();
        boolean wasLoaded = false;
        try {
            if (this.getCachedInput() != null) return new BlocksIndexInput(this.indexFile);
            this.setCachedInput(new BlocksIndexInput(this.indexFile));
            this.getCachedInput().open();
            wasLoaded = true;
            return new BlocksIndexInput(this.indexFile);
        }
        catch (IOException iOException) {
            return new BlocksIndexInput(this.indexFile);
        }
        finally {
            if (wasLoaded && this.getCachedInput() != null) {
                return this.getCachedInput();
            }
            this.setCachedInput(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.getCachedInput() != null) {
            try {
                this.getCachedInput().close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.setCachedInput(null);
            }
        }
    }

    @Override
    public void dispose() {
        this.close();
        this.indexFile.delete();
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = str + "(length: " + this.getIndexFile().getSize() + ")";
        return str;
    }

    @Override
    public void setDoCache(boolean theDoCache) {
        this.doCache = theDoCache;
    }

    public BlocksIndexInput getCachedInput() {
        return this.cachedInput;
    }

    public void setCachedInput(BlocksIndexInput theCachedInput) {
        this.cachedInput = theCachedInput;
    }

    public String getResourceFileName() {
        return this.resourceFileName;
    }
}

