/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util.validators;

import com.jaspersoft.jasperserver.core.util.validators.InputValidator;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegExpValidator<T>
implements InputValidator<T> {
    private static final Log log = LogFactory.getLog(RegExpValidator.class);
    private Pattern pattern;

    @Override
    public boolean isValid(T t) {
        if (t == null) {
            return false;
        }
        if (this.getPattern() == null) {
            return true;
        }
        boolean isValid = this.getPattern().matcher(t.toString()).matches();
        if (!isValid && log.isDebugEnabled()) {
            log.debug((Object)String.format("Email address %s not valid.", t.toString()));
        }
        return isValid;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

