/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.xmla;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapManagementService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.RepositoryCatalogLocator;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;

public class XmlaHandlerImpl
extends XmlaHandler {
    private static final Log log = LogFactory.getLog(XmlaHandlerImpl.class);
    private static final String XMLA_PREFIX = "xmla";
    protected TenantService tenantService;
    private OlapConnectionService mConnectionService;
    private RepositoryService mRepository;
    private OlapManagementService olapManagementService;

    public XmlaHandlerImpl(DataSourcesConfig.DataSources dataSources, CatalogLocator catalogLocator, RepositoryService repository, OlapConnectionService connectionService, OlapManagementService olapManagementService) {
        super(dataSources, catalogLocator, XMLA_PREFIX);
        this.setRepository(repository);
        this.setConnectionService(connectionService);
        this.setOlapManagementService(olapManagementService);
    }

    protected Connection getConnection(DataSourcesConfig.Catalog catalog, String role) throws XmlaException {
        Map dsMap = this.getDataSourceEntries();
        for (Object key : dsMap.keySet()) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DATASOURCE KEY=" + key + " " + key.getClass() + " ,VALUE=" + dsMap.get(key) + " " + dsMap.get(key).getClass()));
        }
        DataSourcesConfig.DataSource ds = catalog.getDataSource();
        return this.getConnection(ds, catalog.definition, role);
    }

    protected Connection getConnection(DataSourcesConfig.DataSource ds, String catalogUrl, String role) throws XmlaException {
        if (log.isDebugEnabled()) {
            if (ds == null) {
                log.debug((Object)"XmlaHandlerImpl.getConnection: ds is null");
            } else {
                log.debug((Object)("XmlaHandlerImpl.getConnection: ds.dataSourceInfo=" + ds.getDataSourceInfo()));
            }
        }
        ExecutionContext context = null;
        MondrianConnection monConn = this.lookupXmlaConnection(context, ds);
        Util.PropertyList connectProperties = this.getConnectionService().getMondrianConnectProperties(context, monConn);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && null == role) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", (Throwable)new SecurityException("Access denied for data source needing authentication"));
        }
        if (role != null && role.trim().length() != 0) {
            connectProperties.put(RolapConnectionProperties.Role.toString(), role);
        }
        return DriverManager.getConnection((Util.PropertyList)connectProperties, (CatalogLocator)new RepositoryCatalogLocator());
    }

    protected Connection getConnection(DataSourcesConfig.Catalog catalog, Role role, String roleName) throws XmlaException {
        DataSourcesConfig.DataSource ds = catalog.getDataSource();
        try {
            Connection conn = this.getConnection(ds, catalog.definition, roleName);
            if (role != null) {
                conn.setRole(role);
            }
            return conn;
        }
        catch (AccessDeniedException e) {
            return null;
        }
    }

    protected Connection getConnection(XmlaRequest request) throws XmlaException {
        log.debug((Object)"XmlaHandlerImpl:getConnection");
        Map dataSourcesMap = this.getDataSourceEntries();
        Map properties = request.getProperties();
        String dataSourceInfo = (String)properties.get("DataSourceInfo");
        if (!dataSourcesMap.containsKey(dataSourceInfo)) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", (Throwable)Util.newError((String)("no data source is configured with name '" + dataSourceInfo + "'")));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("XmlaHandlerImpl.getConnection: dataSourceInfo=" + dataSourceInfo));
        }
        DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)dataSourcesMap.get(dataSourceInfo);
        return this.getConnection(ds, null, request.getRole().toString());
    }

    protected MondrianConnection lookupXmlaConnection(ExecutionContext context, DataSourcesConfig.DataSource ds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up DataSource name=" + ds.name + ", info=" + ds.dataSourceInfo + ", url=" + ds.url));
        }
        MondrianConnection result = null;
        RepositoryService rep = this.getRepository();
        FilterCriteria f = FilterCriteria.createFilter(MondrianXMLADefinition.class);
        String[] tenantid = ds.dataSourceInfo.split("TenantID=");
        if (tenantid.length < 2) {
            f.addNegatedFilterElement((FilterElement)FilterCriteria.createAncestorFolderFilter((String)"/organizations"));
        } else {
            tenantid = tenantid[1].split(";");
            Tenant t = this.tenantService.getTenant(null, tenantid[0]);
            f.addFilterElement((FilterElement)FilterCriteria.createAncestorFolderFilter((String)t.getTenantFolderUri()));
            log.debug((Object)("looking under " + t.getTenantFolderUri()));
        }
        List lookups = rep.loadResourcesList(context, f);
        if (lookups == null || lookups.size() == 0) {
            log.error((Object)"No XMLA Definitions");
        } else {
            Iterator it = lookups.iterator();
            while (it.hasNext()) {
                MondrianXMLADefinition xmlaDef = (MondrianXMLADefinition)rep.getResource(context, ((ResourceLookup)it.next()).getURIString());
                if (ds.name == null || !ds.name.contains("DataSource=" + xmlaDef.getCatalog() + ";")) continue;
                result = (MondrianConnection)this.getConnectionService().dereference(context, xmlaDef.getMondrianConnection());
                log.debug((Object)("Connection Found for catalog: " + xmlaDef.getCatalog()));
                this.getOlapManagementService().notifySchemaUse(null, (Resource)result);
                break;
            }
        }
        if (result == null) {
            log.error((Object)("Mondrian XMLA Definition not found for name: " + ds.name));
        }
        return result;
    }

    public OlapConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public void setConnectionService(OlapConnectionService cs) {
        this.mConnectionService = cs;
    }

    public RepositoryService getRepository() {
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public OlapManagementService getOlapManagementService() {
        return this.olapManagementService;
    }

    public void setOlapManagementService(OlapManagementService olapManagementService) {
        this.olapManagementService = olapManagementService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

