/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.xmla;

import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.war.xmla.UpdatableXMLAContainer;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLAUpdateListener {
    private Set registeredListeners = new LinkedHashSet();
    private static final Log log = LogFactory.getLog(XMLAUpdateListener.class);

    public void registerListener(UpdatableXMLAContainer updatableXMLAContainer) {
        if (updatableXMLAContainer != null) {
            this.registeredListeners.add(updatableXMLAContainer);
        }
    }

    public boolean unregisterListener(UpdatableXMLAContainer updatableXMLAContainer) {
        if (updatableXMLAContainer != null) {
            return this.registeredListeners.remove(updatableXMLAContainer);
        }
        return false;
    }

    public void notifyListeners(MondrianXMLADefinition oldDef, MondrianXMLADefinition newDef) {
        for (UpdatableXMLAContainer updatableXMLAContainer : this.registeredListeners) {
            try {
                updatableXMLAContainer.updateXMLAConnection(oldDef, newDef);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot update XMLA Connection!", (Throwable)ex);
            }
        }
    }
}

