/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessagesCalendarFormatProvider
implements CalendarFormatProvider,
Serializable {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;
    private String datePatternKey;
    private String calendarDatePatternKey;
    private String datetimePatternKey;
    private String timePatternKey;
    private String calendarDatetimeSeparatorKey;
    private String calendarTimePatternKey;
    private boolean lenientFormats;

    @Override
    public String getCalendarDatePattern() {
        return this.messages.getMessage(this.getCalendarDatePatternKey(), null, this.getLocale());
    }

    @Override
    public String getCalendarTimePattern() {
        return this.messages.getMessage(this.getCalendarTimePatternKey(), null, "hh:mm", this.getLocale());
    }

    @Override
    public String getCalendarDatetimePattern() {
        return this.getCalendarDatePattern() + this.getCalendarDatetimeSeparatorKey() + this.getCalendarTimePattern();
    }

    @Override
    public DateFormat getDateFormat() {
        String pattern = this.getDatePattern();
        return this.createFormat(pattern);
    }

    @Override
    public String getDatePattern() {
        return this.messages.getMessage(this.getDatePatternKey(), null, this.getLocale());
    }

    protected SimpleDateFormat createFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setLenient(this.isLenientFormats());
        return format;
    }

    @Override
    public DateFormat getDatetimeFormat() {
        String pattern = this.getDatetimePattern();
        return this.createFormat(pattern);
    }

    @Override
    public String getDatetimePattern() {
        return this.messages.getMessage(this.getDatetimePatternKey(), null, this.getLocale());
    }

    @Override
    public DateFormat getTimeFormat() {
        String pattern = this.messages.getMessage(this.getTimePatternKey(), null, this.getLocale());
        return this.createFormat(pattern);
    }

    @Override
    public String getTimePattern() {
        return this.messages.getMessage(this.getTimePatternKey(), null, this.getLocale());
    }

    public String getCalendarDatePatternKey() {
        return this.calendarDatePatternKey;
    }

    public void setCalendarDatePatternKey(String calendarDatePatternKey) {
        this.calendarDatePatternKey = calendarDatePatternKey;
    }

    public String getCalendarDatetimeSeparatorKey() {
        return this.calendarDatetimeSeparatorKey;
    }

    public void setCalendarDatetimeSeparatorKey(String calendarDatetimeSeparatorKey) {
        this.calendarDatetimeSeparatorKey = calendarDatetimeSeparatorKey;
    }

    public String getDatePatternKey() {
        return this.datePatternKey;
    }

    public void setDatePatternKey(String datePatternKey) {
        this.datePatternKey = datePatternKey;
    }

    public String getDatetimePatternKey() {
        return this.datetimePatternKey;
    }

    public void setDatetimePatternKey(String datetimePatternKey) {
        this.datetimePatternKey = datetimePatternKey;
    }

    public String getTimePatternKey() {
        return this.timePatternKey;
    }

    public void setTimePatternKey(String timePatternKey) {
        this.timePatternKey = timePatternKey;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public boolean isLenientFormats() {
        return this.lenientFormats;
    }

    public void setLenientFormats(boolean lenientFormats) {
        this.lenientFormats = lenientFormats;
    }

    public String getCalendarTimePatternKey() {
        return this.calendarTimePatternKey;
    }

    public void setCalendarTimePatternKey(String calendarTimePatternKey) {
        this.calendarTimePatternKey = calendarTimePatternKey;
    }
}

