/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeUtil {
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";

    public static Date parseDate(String pattern, String date) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse date '" + date + "' using pattern '" + pattern + "'.");
        }
    }

    public static Date parseDate(String date) {
        return DateTimeUtil.parseDate(DEFAULT_DATE_TIME_PATTERN, date);
    }

    public static java.sql.Date parseSQLDate(String pattern, String date) {
        return new java.sql.Date(DateTimeUtil.parseDate(pattern, date).getTime());
    }

    public static java.sql.Date parseSQLDate(String date) {
        return DateTimeUtil.parseSQLDate(DEFAULT_DATE_PATTERN, date);
    }

    public static Timestamp parseTimestamp(String pattern, String dateTime) {
        return new Timestamp(DateTimeUtil.parseDate(pattern, dateTime).getTime());
    }

    public static Timestamp parseTimestamp(String dateTime) {
        return DateTimeUtil.parseTimestamp(DEFAULT_DATE_TIME_PATTERN, dateTime);
    }

    public static Time parseTime(String pattern, String time) {
        return new Time(DateTimeUtil.parseDate(pattern, time).getTime());
    }

    public static Time parseTime(String time) {
        return DateTimeUtil.parseTime(DEFAULT_TIME_PATTERN, time);
    }
}

