/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.themes.NotThemeRootFolderException;
import com.jaspersoft.jasperserver.war.themes.ThemeFolderExistsException;
import com.jaspersoft.jasperserver.war.themes.ThemeService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class ThemeServiceImpl
implements ThemeService {
    private TenantService tenantService;
    private ConfigurationBean configurationBean;
    private RepositoryService repositoryService;
    private ResourceFactory resourceFactory;

    @Override
    public String getActiveTheme(ExecutionContext executionContext, String tenantId) {
        Tenant tenant = this.tenantService.getTenant(executionContext, tenantId);
        if (tenant != null) {
            return tenant.getTheme();
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void setActiveTheme(ExecutionContext executionContext, String tenantId, String themeName) {
        this.tenantService.setTenantActiveTheme(executionContext, tenantId, themeName);
    }

    @Override
    public boolean isThemeFolder(ExecutionContext executionContext, String folderUri) {
        String themeFolder = this.configurationBean.getThemeFolderName() + "/";
        int idx = folderUri.indexOf(themeFolder);
        if (idx < 0) {
            return false;
        }
        String themeName = folderUri.substring(idx + themeFolder.length());
        if (themeName.length() == 0 || themeName.contains("/")) {
            return false;
        }
        if (folderUri.startsWith(themeFolder)) {
            return true;
        }
        Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(executionContext, folderUri);
        if (tenant != null) {
            String tenantThemeFolder = (tenant.getTenantFolderUri() + themeFolder).replace("//", "/");
            return folderUri.startsWith(tenantThemeFolder);
        }
        return false;
    }

    @Override
    public boolean isThemeRootFolder(ExecutionContext executionContext, String folderUri) {
        String themeFolder = this.configurationBean.getThemeFolderName();
        if (!folderUri.endsWith(themeFolder)) {
            return false;
        }
        if (folderUri.startsWith(themeFolder)) {
            return true;
        }
        Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(executionContext, folderUri);
        if (tenant != null) {
            String tenantThemeFolder = (tenant.getTenantFolderUri() + themeFolder).replace("//", "/");
            return folderUri.equals(tenantThemeFolder);
        }
        return false;
    }

    @Override
    public boolean isActiveThemeFolder(ExecutionContext executionContext, String folderUri) {
        if (!this.isThemeFolder(executionContext, folderUri)) {
            return false;
        }
        String themeName = folderUri.substring(folderUri.lastIndexOf("/") + 1);
        Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(executionContext, folderUri);
        if (tenant != null) {
            return themeName.equals(tenant.getTheme());
        }
        try {
            tenant = this.tenantService.getTenant(executionContext, "organizations");
            return themeName.equals(tenant.getTheme());
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public byte[] getZipedTheme(ExecutionContext executionContext, String folderUri) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        this.zipThemeFolder(executionContext, folderUri, zos, "");
        zos.close();
        return baos.toByteArray();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void addZippedTheme(ExecutionContext executionContext, String folderUri, String themeName, byte[] themeZip) throws Exception {
        this.addZippedTheme(executionContext, folderUri, themeName, themeZip, false);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void addZippedTheme(ExecutionContext executionContext, String folderUri, String themeName, byte[] themeZip, boolean overwrite) throws Exception {
        if (!this.isThemeRootFolder(executionContext, folderUri)) {
            throw new NotThemeRootFolderException();
        }
        String themeUri = folderUri + "/" + themeName;
        if (this.repositoryService.getFolder(executionContext, themeUri) != null) {
            if (!overwrite) {
                throw new ThemeFolderExistsException();
            }
            this.repositoryService.deleteFolder(executionContext, themeUri);
        }
        this.getOrCreateFolder(executionContext, themeUri);
        ByteArrayInputStream bais = new ByteArrayInputStream(themeZip);
        ZipInputStream zis = new ZipInputStream(bais);
        HashSet<String> subfolders = new HashSet<String>();
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            int read;
            String path;
            String name = path = entry.getName();
            String resFolder = themeUri;
            if (path.contains("/")) {
                if (path.endsWith("/")) continue;
                name = path.substring(path.lastIndexOf("/") + 1);
                String[] folders = path.split("/");
                for (int i = 0; i < folders.length - 1; ++i) {
                    String folder = folders[i];
                    if (folder.length() == 0) continue;
                    resFolder = resFolder + "/" + folder;
                    if (subfolders.contains(folder)) continue;
                    Folder f = this.getOrCreateFolder(executionContext, resFolder);
                    subfolders.add(resFolder);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((read = zis.read(buf, 0, 1024)) != -1) {
                baos.write(buf, 0, read);
            }
            String type = name.toUpperCase().endsWith(".CSS") ? "css" : "img";
            String label = name;
            String desc = name;
            try {
                String jsonStr = new String(entry.getExtra());
                JSONObject json = new JSONObject(jsonStr);
                label = json.getString("label");
                desc = json.getString("description");
            }
            catch (Exception ex) {
                // empty catch block
            }
            String resourceURI = resFolder + "/" + name;
            FileResource fileResource = (FileResource)this.repositoryService.getResource(executionContext, resourceURI);
            if (fileResource == null) {
                fileResource = (FileResource)this.resourceFactory.newResource(executionContext, FileResource.class);
            }
            fileResource.setName(name);
            fileResource.setLabel(label);
            fileResource.setDescription(desc);
            fileResource.setParentFolder(resFolder);
            fileResource.setData(baos.toByteArray());
            fileResource.setFileType(type);
            this.repositoryService.saveResource(executionContext, (Resource)fileResource);
        }
        zis.close();
    }

    protected void zipThemeFolder(ExecutionContext executionContext, String folderUri, ZipOutputStream zos, String basePath) throws IOException {
        List folders;
        FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderUri));
        List resources = this.repositoryService.loadResourcesList(null, criteria);
        if (resources != null) {
            for (ResourceLookup res : resources) {
                ZipEntry ze = new ZipEntry(basePath + res.getName());
                ze.setTime(res.getUpdateDate().getTime());
                ze.setExtra(this.readExtraParameters((Resource)res).getBytes());
                zos.putNextEntry(ze);
                FileResourceData frd = this.repositoryService.getResourceData(executionContext, res.getURIString());
                byte[] data = frd.getData();
                zos.write(data);
            }
        }
        if ((folders = this.repositoryService.getSubFolders(executionContext, folderUri)) != null) {
            for (Folder folder : folders) {
                String name = basePath + folder.getName() + "/";
                this.zipThemeFolder(executionContext, folder.getURIString(), zos, name);
            }
        }
    }

    protected String readExtraParameters(Resource res) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("label", (Object)res.getLabel());
            obj.put("description", (Object)res.getDescription());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj.toString();
    }

    protected Folder getOrCreateFolder(ExecutionContext executionContext, String uri) {
        Folder f = this.repositoryService.getFolder(executionContext, uri);
        if (f == null) {
            int k = uri.lastIndexOf("/");
            String parent = uri.substring(0, k);
            String name = uri.substring(k + 1);
            f = new FolderImpl();
            f.setName(name);
            f.setLabel(name);
            f.setParentFolder(parent);
            this.repositoryService.saveFolder(executionContext, f);
            f = this.repositoryService.getFolder(executionContext, uri);
        }
        return f;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }
}

