/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.servlet.theme.AbstractThemeResolver;

public class MTThemeResolver
extends AbstractThemeResolver {
    private TenantService tenantService;

    public String resolveThemeName(HttpServletRequest request) {
        String theme;
        TenantQualified tenantQualified;
        String tenantId;
        Tenant tenant;
        Authentication auth;
        if (this.isLoginPage(request)) {
            return this.getRootActive();
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && (auth = securityContext.getAuthentication()) != null && auth.getPrincipal() != null && auth.getPrincipal() instanceof TenantQualified && (tenant = this.tenantService.getTenant(null, tenantId = (tenantQualified = (TenantQualified)auth.getPrincipal()).getTenantId() != null ? tenantQualified.getTenantId() : "organizations")) != null && (theme = tenant.getTheme()) != null && theme.length() > 0) {
            return theme;
        }
        return this.getRootActive();
    }

    protected String getRootActive() {
        Tenant root = this.tenantService.getTenant(null, "organizations");
        if (root.getTheme() != null && root.getTheme().length() > 0) {
            return root.getTheme();
        }
        return this.getDefaultThemeName();
    }

    protected boolean isLoginPage(HttpServletRequest request) {
        return request.getRequestURI().contains("login.jsp");
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
        throw new UnsupportedOperationException("MTThemeResolver does not support using setThemeName. Set the active theme for the organization instead.");
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

