/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.BaseTreeDataProvider;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class DataSourceTreeDataProvider
extends BaseTreeDataProvider {
    public static final Logger log = Logger.getLogger(DataSourceTreeDataProvider.class);
    private List<String> supportedClasses;

    @Override
    protected TreeNode createRoot(ExecutionContext executionContext) {
        ArrayList<ResourceLookup> lookups = new ArrayList<ResourceLookup>();
        for (String clazz : this.supportedClasses) {
            try {
                ResourceLookup[] lookupsArray = this.getRepositoryService().findResource(executionContext, FilterCriteria.createFilter(Class.forName(clazz)));
                if (lookupsArray == null) continue;
                lookups.addAll(Arrays.asList(lookupsArray));
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"DataSourceTreeDataProvider supported class not found: ", (Throwable)e);
            }
        }
        Folder rootFolder = this.getRepositoryService().getFolder(executionContext, "/");
        TreeNodeImpl root = new TreeNodeImpl((TreeDataProvider)this, rootFolder.getName(), rootFolder.getLabel(), rootFolder.getResourceType(), rootFolder.getURIString(), 1);
        for (ResourceLookup lookup : lookups) {
            TreeNode parent = this.getParentFolderNode(root, lookup.getURIString());
            parent.getChildren().add(new TreeNodeImpl(this, lookup.getName(), lookup.getLabel(), lookup.getResourceType(), lookup.getURIString()));
        }
        return root;
    }

    public void setSupportedClasses(List<String> supportedClasses) {
        this.supportedClasses = supportedClasses;
    }
}

