/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.dto;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import java.io.Serializable;

public class ResourceReferenceDTO
implements Serializable {
    private String source;
    private Resource localResource;
    private String referenceURI;

    public ResourceReferenceDTO() {
        this(null);
    }

    public ResourceReferenceDTO(ResourceReference reference) {
        if (reference == null) {
            this.source = "NONE";
        } else if (reference.isLocal()) {
            this.source = "LOCAL";
            this.localResource = (Query)reference.getLocalResource();
        } else {
            this.source = "CONTENT_REPOSITORY";
            this.referenceURI = reference.getReferenceURI();
        }
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public void setReferenceURI(String referenceURI) {
        this.referenceURI = referenceURI;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Resource getLocalResource() {
        return this.localResource;
    }

    public void setLocalResource(Resource localResource) {
        this.localResource = localResource;
    }

    public ResourceReference toResourceReference() {
        ResourceReference ref;
        if (this.getSource().equals("NONE")) {
            ref = null;
        } else if (this.getSource().equals("LOCAL")) {
            ref = new ResourceReference(this.getLocalResource());
        } else if (this.getSource().equals("CONTENT_REPOSITORY")) {
            ref = new ResourceReference(this.getReferenceURI());
        } else {
            String quotedSource = "\"" + this.getSource() + "\"";
            throw new JSException("jsexception.invalid.resource.reference.source", new Object[]{quotedSource});
        }
        return ref;
    }
}

