/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.hyperlinks;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.BaseReportExecutionHyperlinkProducerFactory;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFlowFactory;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportExecutionHyperlinkProducerFactory
extends BaseReportExecutionHyperlinkProducerFactory
implements HyperlinkProducerFlowFactory {
    private static final long serialVersionUID = 1L;
    private String attributeReportLocale;
    private String urlParameterReportLocale;

    @Override
    public JRHyperlinkProducer getHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
        HyperlinkProducer hyperlinkProducer = new HyperlinkProducer(request, response);
        return hyperlinkProducer;
    }

    public String getAttributeReportLocale() {
        return this.attributeReportLocale;
    }

    public void setAttributeReportLocale(String attributeReportLocale) {
        this.attributeReportLocale = attributeReportLocale;
    }

    public String getUrlParameterReportLocale() {
        return this.urlParameterReportLocale;
    }

    public void setUrlParameterReportLocale(String urlParameterReportLocale) {
        this.urlParameterReportLocale = urlParameterReportLocale;
    }

    public class HyperlinkProducer
    extends BaseReportExecutionHyperlinkProducerFactory.BaseHyperlinkProducer {
        private final HttpServletResponse response;
        private final String contextPath;
        private final String flowExecutionKey;
        private final String reportUnit;
        private final Locale reportLocale;
        private boolean viewAsDashboardFrame;

        public HyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
            super((BaseReportExecutionHyperlinkProducerFactory)ReportExecutionHyperlinkProducerFactory.this);
            this.viewAsDashboardFrame = false;
            this.response = response;
            this.flowExecutionKey = (String)request.getAttribute("flowExecutionKey");
            this.contextPath = request.getContextPath();
            this.reportUnit = (String)request.getAttribute(ReportExecutionHyperlinkProducerFactory.this.getUrlParameterReportUnit());
            this.reportLocale = (Locale)request.getAttribute(ReportExecutionHyperlinkProducerFactory.this.getAttributeReportLocale());
            this.viewAsDashboardFrame = request.getAttribute("viewAsDashboardFrame") != null && request.getAttribute("viewAsDashboardFrame").toString().equalsIgnoreCase("true");
        }

        public String getHyperlink(JRPrintHyperlink hyperlink) {
            String uri = super.getHyperlink(hyperlink);
            return this.response.encodeURL(uri);
        }

        protected boolean isJiveLink(JRPrintHyperlink hyperlink) {
            JRPrintHyperlinkParameters parameters = hyperlink.getHyperlinkParameters();
            if (parameters != null) {
                for (JRPrintHyperlinkParameter param : parameters.getParameters()) {
                    if (!"jr_ctxid".equals(param.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        protected void appendSubflowParams(JRPrintHyperlink hyperlink, BaseReportExecutionHyperlinkProducerFactory.BaseHyperlinkProducer.URLParameters urlParams) {
            if (this.flowExecutionKey != null) {
                String eventId = this.isJiveLink(hyperlink) ? "jiveRun" : "drillReport";
                urlParams.appendParameter("_eventId_" + eventId, "");
                urlParams.appendParameter("_flowExecutionKey", this.flowExecutionKey);
            }
        }

        protected void appendAdditionalParameters(JRPrintHyperlink hyperlink, BaseReportExecutionHyperlinkProducerFactory.BaseHyperlinkProducer.URLParameters urlParams) {
            if (hyperlink.getHyperlinkTargetValue() == HyperlinkTargetEnum.SELF) {
                this.appendSubflowParams(hyperlink, urlParams);
            }
            if (this.reportUnit != null && !urlParams.hasParameter(ReportExecutionHyperlinkProducerFactory.this.getUrlParameterReportUnit())) {
                urlParams.appendParameter(ReportExecutionHyperlinkProducerFactory.this.getUrlParameterReportUnit(), this.reportUnit);
            }
            if (this.reportLocale != null) {
                urlParams.appendParameter(ReportExecutionHyperlinkProducerFactory.this.getUrlParameterReportLocale(), this.reportLocale.toString());
            }
            if (this.viewAsDashboardFrame && !HyperlinkTargetEnum.BLANK.getName().equals(hyperlink.getLinkTarget())) {
                if (this.isJiveLink(hyperlink)) {
                    urlParams.appendParameter("viewAsDashboardFrame", "true");
                } else {
                    urlParams.appendParameter("decorate", "no");
                }
            }
        }

        protected void appendHyperlinkStart(JRPrintHyperlink hyperlink, StringBuffer sb) {
            sb.append(this.contextPath);
        }

        protected Locale getLocale() {
            return LocaleContextHolder.getLocale();
        }
    }
}

