/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.RoleManagerService;
import com.jaspersoft.jasperserver.war.action.BaseManagerAction;
import com.jaspersoft.jasperserver.war.action.EntitiesListManager;
import com.jaspersoft.jasperserver.war.action.EntitiesListState;
import com.jaspersoft.jasperserver.war.common.UsersOperationResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RoleManagerAction
extends BaseManagerAction {
    protected static final String RM_DEFAULT_ROLE = "defaultRole";
    protected static final String UM_ROLE_DETAILS = "roleDetails";
    protected static final String UM_USER_NAME = "userName";
    protected static final String UM_ROLE_NAME = "roleName";
    protected static final String UM_ROLE_NAMES = "roleNames";
    protected static final String UM_FIRST_RESULT = "firstResult";
    protected static final String RM_ASSIGNED_USER_LIST = "assignedUserList";
    protected static final String RM_AVAILABLE_USER_LIST = "availableUserList";
    protected static final String RM_ASSIGN_USERS = "assignUsers";
    protected static final String RM_UNASSIGN_USERS = "unassignUsers";
    protected static final String RM_ROLE_USERS = "rmRoleUsers";
    protected static final String RM_ROLE_USERS_RESTORE = "rmRoleUsersRestore";
    protected static final String JSON_ATTRIBUTE_USER_NAME_SEPARATOR = "userNameSeparator";
    protected static final String JSON_ATTRIBUTE_ROLE_NAME_NOT_SUPPORTED_SYMBOLS = "roleNameNotSupportedSymbols";
    protected static final String JSON_ATTRIBUTE_USER_DEFAULT_ROLE = "userDefaultRole";
    protected static final String JSON_ATTRIBUTE_USER_PASSWORD_MASK = "passwordMask";
    private RoleManagerService roleManagerService;

    public void setRoleManagerService(RoleManagerService roleManagerService) {
        this.roleManagerService = roleManagerService;
    }

    public Event initEvent(RequestContext context) throws Exception {
        this.initState(context);
        JSONObject jsonConfiguration = new JSONObject();
        jsonConfiguration.put(JSON_ATTRIBUTE_ROLE_NAME_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getRoleNameNotSupportedSymbols());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_NAME_SEPARATOR, (Object)this.configuration.getUserNameSeparator());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_DEFAULT_ROLE, (Object)this.configuration.getDefaultRole());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_PASSWORD_MASK, (Object)this.configuration.getPasswordMask());
        jsonConfiguration.put("superuserRole", (Object)"ROLE_SUPERUSER");
        jsonConfiguration.put("adminRole", (Object)"ROLE_ADMINISTRATOR");
        context.getFlowScope().put("configuration", (Object)jsonConfiguration.toString());
        context.getFlowScope().put(RM_DEFAULT_ROLE, (Object)this.getDefaultEntity(context));
        context.getFlowScope().put("defaultEntity", (Object)this.getDefaultEntity(context));
        context.getFlowScope().put("signedUser", (Object)this.getCurrentUser());
        context.getFlowScope().put("currentUserRoles", (Object)this.jsonHelper.convertRoleListToJson(this.getCurrentUserRoles(), null).toString());
        return this.success();
    }

    @Override
    public Event next(RequestContext context) {
        String responseModel;
        BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getEntitiesState();
        try {
            final Set<String> tenantIdSet = this.getSubTenantIdsSet(state.getTenantId());
            List roles = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getRoleItemsPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return RoleManagerAction.this.userService.getTenantVisibleRolesCount(null, tenantIdSet, entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return RoleManagerAction.this.userService.getTenantVisibleRoles(null, tenantIdSet, entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject rolesJson = this.jsonHelper.createRolesResponseJson(roles);
            responseModel = this.jsonHelper.createDataResponseModel(rolesJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event getDetails(RequestContext context) {
        String responseModel;
        BaseManagerAction.State state = this.getState(context);
        String roleName = state.getSelectedEntity();
        try {
            Role role = this.userService.getRole(null, roleName);
            if (role == null) {
                throw new IllegalArgumentException("Cannot find role with name : " + roleName);
            }
            JSONObject usersJson = this.jsonHelper.convertRoleToJson(role, null);
            responseModel = this.jsonHelper.createDataResponseModel(usersJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event nextAssigned(RequestContext context) {
        String responseModel;
        final BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getAssignedEntitiesState();
        try {
            List users = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getEntitiesPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return RoleManagerAction.this.userService.getUsersCountWithRole(null, state.getSelectedEntity(), entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return RoleManagerAction.this.userService.getUsersWithRole(null, state.getSelectedEntity(), entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject usersJson = this.jsonHelper.createUsersResponseJson(users);
            responseModel = this.jsonHelper.createDataResponseModel(usersJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event nextAvailable(RequestContext context) {
        String responseModel;
        final BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getAvailableEntitiesState();
        try {
            List users = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getEntitiesPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return RoleManagerAction.this.userService.getUsersCountWithoutRole(null, state.getSelectedEntity(), entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return RoleManagerAction.this.userService.getUsersWithoutRole(null, state.getSelectedEntity(), entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject usersJson = this.jsonHelper.createUsersResponseJson(users);
            responseModel = this.jsonHelper.createDataResponseModel(usersJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event exist(RequestContext context) {
        String responseModel;
        String roleName = this.getParameter(context, "entityName");
        try {
            Role role = this.userService.getRole(null, roleName);
            JSONObject existJson = this.jsonHelper.createExistJson(role != null);
            responseModel = this.jsonHelper.createDataResponseModel(existJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event delete(RequestContext context) {
        String responseModel;
        String roleName = this.getParameter(context, "entity");
        try {
            responseModel = this.jsonHelper.createSuccessResponseModel();
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        try {
            if (roleName.length() <= 0) {
                throw new IllegalArgumentException("Role name is empty.");
            }
            this.createAuditEvent("deleteRole");
            this.userService.deleteRole(null, roleName);
            this.closeAuditEvent("deleteRole");
            this.setUsersOperationResult(context, new UsersOperationResult(roleName));
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event deleteAll(RequestContext context) {
        String responseModel;
        block8: {
            try {
                responseModel = this.jsonHelper.createSuccessResponseModel();
            }
            catch (JSONException e) {
                return this.error((Exception)((Object)e));
            }
            try {
                List<String> roleNames = this.getEntities(context);
                if (roleNames.size() > 0) {
                    this.createAuditEvent("deleteAllRoles");
                    this.roleManagerService.deleteAll(null, roleNames);
                    this.closeAuditEvent("deleteAllRoles");
                    for (String roleName : roleNames) {
                        this.setUsersOperationResult(context, new UsersOperationResult(roleName));
                    }
                    break block8;
                }
                throw new IllegalArgumentException("Role name is empty.");
            }
            catch (Exception e) {
                try {
                    responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
                }
                catch (JSONException e1) {
                    return this.error(e);
                }
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event create(RequestContext context) {
        String responseModel;
        try {
            responseModel = this.jsonHelper.createSuccessResponseModel();
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        try {
            Role role;
            String roleJson = this.getParameter(context, "entity");
            if (roleJson != null && roleJson.length() > 0) {
                Tenant tenant;
                role = this.jsonHelper.convertJsonToRole(roleJson);
                if (role.getTenantId() != null && (tenant = this.tenantService.getTenant(null, role.getTenantId())) == null) {
                    throw new IllegalArgumentException("Cannot find organization with id : " + role.getTenantId());
                }
            } else {
                throw new IllegalAccessException("Error when creating role");
            }
            this.createAuditEvent("createRole");
            this.userService.putRole(null, role);
            this.closeAuditEvent("createRole");
            this.setUsersOperationResult(context, new UsersOperationResult(role.getRoleName()));
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event initEdit(RequestContext context) throws Exception {
        String roleName = this.getRoleName(context, false);
        this.setUsersOperationResult(context, new UsersOperationResult(roleName));
        this.log.info((Object)("Init edit for role : " + roleName));
        context.getRequestScope().put("ajaxResponseModel", (Object)this.jsonHelper.createSuccessResponseModel());
        return this.success();
    }

    public Event updateRole(RequestContext context) throws Exception {
        String responseModel;
        block5: {
            try {
                responseModel = this.jsonHelper.createSuccessResponseModel();
            }
            catch (JSONException e) {
                return this.error((Exception)((Object)e));
            }
            try {
                String roleJson = this.getParameter(context, "entity");
                String roleName = this.getParameter(context, "entityName");
                String assignedJson = this.getParameter(context, "assignedEntities");
                String unassignedJson = this.getParameter(context, "unassignedEntities");
                if (roleJson == null || roleJson.length() <= 0) break block5;
                Role role = this.jsonHelper.convertJsonToRole(roleJson);
                Set<User> assigned = this.jsonHelper.convertJsonArrayToUsers(assignedJson);
                Set<User> unassigned = this.jsonHelper.convertJsonArrayToUsers(unassignedJson);
                if (role != null && role.getRoleName().trim().length() > 0) {
                    this.createAuditEvent("updateRole");
                    this.roleManagerService.updateRole(null, roleName, role, assigned, unassigned);
                    this.closeAuditEvent("updateRole");
                    break block5;
                }
                throw new IllegalArgumentException("Error when updating role details");
            }
            catch (Exception e) {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event cancelEdit(RequestContext context) throws Exception {
        String roleName = this.getRoleName(context, false);
        this.setUsersOperationResult(context, new UsersOperationResult(roleName));
        this.log.info((Object)("Cancel edit role : " + roleName));
        context.getRequestScope().put("ajaxResponseModel", (Object)this.jsonHelper.createSuccessResponseModel());
        return this.success();
    }

    public Event initChangeUsers(RequestContext context) throws Exception {
        String roleName = this.getRoleName(context, false);
        UsersOperationResult usersOperationResult = this.getUsersOperationResult(context, roleName);
        this.getSession(context).put(RM_ROLE_USERS_RESTORE, usersOperationResult.clone());
        this.log.info((Object)("Init change users for role : " + roleName));
        context.getRequestScope().put("ajaxResponseModel", (Object)this.jsonHelper.createSuccessResponseModel());
        return this.success();
    }

    public Event revertUsersChanges(RequestContext context) throws Exception {
        String roleName = this.getRoleName(context, false);
        UsersOperationResult usersOperationResultRestore = (UsersOperationResult)this.getSession(context).get(RM_ROLE_USERS_RESTORE);
        this.setUsersOperationResult(context, usersOperationResultRestore);
        this.log.info((Object)("Revert user changes for role : " + roleName));
        context.getRequestScope().put("ajaxResponseModel", (Object)this.jsonHelper.createSuccessResponseModel());
        return this.success();
    }

    public Event loadAvailableUsers(RequestContext context) throws Exception {
        String responseModel;
        String roleName = this.getRoleName(context, false);
        String userName = this.getUserName(context);
        int firstResult = this.getFirstResult(context);
        try {
            JSONObject availableUsers = this.getUnassignedUsers(context, roleName, userName, firstResult);
            responseModel = this.jsonHelper.createDataResponseModel(availableUsers);
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event loadAssignedUsers(RequestContext context) throws Exception {
        String responseModel;
        String roleName = this.getRoleName(context, false);
        String userName = this.getUserName(context);
        int firstResult = this.getFirstResult(context);
        try {
            JSONObject assignedUsers = this.getAssignedUsers(context, roleName, userName, firstResult);
            responseModel = this.jsonHelper.createDataResponseModel(assignedUsers);
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event updateRoleUsers(RequestContext context) throws Exception {
        String responseModel;
        String roleName = this.getRoleName(context, false);
        try {
            Object tenantIdSet = null;
            this.assignUsers(context, roleName, this.getAssignUsers(context));
            this.unassignUsers(context, roleName, this.getUnassignUsers(context));
            String availableListUserName = this.getUserName(this.getAvailableUserList(context));
            int availableListFirstResult = this.getFirstResult(this.getAvailableUserList(context));
            String assignedListUserName = this.getUserName(this.getAssignedUserList(context));
            int assignedListFirstResult = this.getFirstResult(this.getAssignedUserList(context));
            JSONObject userChanges = new JSONObject();
            userChanges.put(RM_AVAILABLE_USER_LIST, (Object)this.getUnassignedUsers(context, roleName, availableListUserName, availableListFirstResult));
            userChanges.put(RM_ASSIGNED_USER_LIST, (Object)this.getAssignedUsers(context, roleName, assignedListUserName, assignedListFirstResult));
            responseModel = this.jsonHelper.createDataResponseModel(userChanges);
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    private JSONObject getUnassignedUsers(RequestContext context, String roleName, String userName, int firstResult) throws Exception {
        Set unassignedUserNames;
        int maxResults = 10;
        Set assignedUserNames = this.getUsersOperationResult(context, roleName).getAssignedUsers();
        PaginatedOperationResult result = this.roleManagerService.getUsersWithoutRole(null, roleName, userName, assignedUserNames, unassignedUserNames = this.getUsersOperationResult(context, roleName).getUnassignedUsers(), firstResult, maxResults);
        JSONObject availableUserListJson = result.getResult() != null && !result.getResult().isEmpty() ? this.jsonHelper.createUsersResponseJson(result.getResult()) : this.jsonHelper.createEmptyUserListResponseJson();
        return availableUserListJson;
    }

    private JSONObject getAssignedUsers(RequestContext context, String roleName, String userName, int firstResult) throws Exception {
        Set unassignedUserNames;
        int maxResults = 10;
        Set assignedUserNames = this.getUsersOperationResult(context, roleName).getAssignedUsers();
        PaginatedOperationResult result = this.roleManagerService.getUsersWithRole(null, roleName, userName, assignedUserNames, unassignedUserNames = this.getUsersOperationResult(context, roleName).getUnassignedUsers(), firstResult, maxResults);
        JSONObject assignedUserListJson = result.getResult() != null && !result.getResult().isEmpty() ? this.jsonHelper.createUsersResponseJson(result.getResult()) : this.jsonHelper.createEmptyUserListResponseJson();
        return assignedUserListJson;
    }

    private int getFirstResult(JSONObject json) throws Exception {
        int firstResult = 0;
        if (json != null && json.has(UM_FIRST_RESULT)) {
            firstResult = json.getInt(UM_FIRST_RESULT);
        }
        return firstResult;
    }

    private String getUserName(JSONObject json) throws Exception {
        String userName = "";
        if (json != null && json.has(UM_USER_NAME)) {
            userName = json.getString(UM_USER_NAME);
        }
        return userName;
    }

    private void assignUsers(RequestContext context, String roleName, Set userNames) throws Exception {
        UsersOperationResult result = this.getUsersOperationResult(context, roleName);
        Set assigned = result.getAssignedUsers();
        assigned.addAll(userNames);
        Set unassigned = result.getUnassignedUsers();
        unassigned.removeAll(userNames);
    }

    private void unassignUsers(RequestContext context, String roleName, Set userNames) throws Exception {
        UsersOperationResult result = this.getUsersOperationResult(context, roleName);
        Set unassigned = result.getUnassignedUsers();
        unassigned.addAll(userNames);
        Set assigned = result.getAssignedUsers();
        assigned.removeAll(userNames);
    }

    private String getRoleJson(RequestContext context) {
        return context.getRequestParameters().get(UM_ROLE_DETAILS);
    }

    private String getUserName(RequestContext context) {
        String name = this.getDecodedRequestParameter(context, UM_USER_NAME);
        return name != null ? name : "";
    }

    private String getRoleName(RequestContext context, boolean decode) {
        String name = decode ? this.getDecodedRequestParameter(context, UM_ROLE_NAME) : context.getRequestParameters().get(UM_ROLE_NAME);
        return name != null ? name : "";
    }

    private List<String> getRoleNames(RequestContext context) throws JSONException {
        ArrayList<String> roleNames = new ArrayList<String>();
        String json = context.getRequestParameters().get(UM_ROLE_NAMES);
        if (json != null) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                roleNames.add(array.getString(i));
            }
        }
        return roleNames;
    }

    private Set getAssignUsers(RequestContext context) throws Exception {
        String assignedUsersParam = context.getRequestParameters().get(RM_ASSIGN_USERS);
        HashSet<String> assignedUsers = new HashSet<String>();
        if (assignedUsersParam != null && assignedUsersParam.length() > 0) {
            JSONArray assignedUsersArray = new JSONArray(assignedUsersParam);
            for (int i = 0; i < assignedUsersArray.length(); ++i) {
                assignedUsers.add(assignedUsersArray.getString(i));
            }
        }
        return assignedUsers;
    }

    private Set getUnassignUsers(RequestContext context) throws Exception {
        String unassignUsersParam = context.getRequestParameters().get(RM_UNASSIGN_USERS);
        HashSet<String> unassignUsers = new HashSet<String>();
        if (unassignUsersParam != null && unassignUsersParam.length() > 0) {
            JSONArray assignedUsersArray = new JSONArray(unassignUsersParam);
            for (int i = 0; i < assignedUsersArray.length(); ++i) {
                unassignUsers.add(assignedUsersArray.getString(i));
            }
        }
        return unassignUsers;
    }

    private JSONObject getAvailableUserList(RequestContext context) throws Exception {
        JSONObject availableUserList;
        String availableUserListParam = context.getRequestParameters().get(RM_AVAILABLE_USER_LIST);
        if (availableUserListParam != null && availableUserListParam.length() > 0) {
            availableUserList = new JSONObject(availableUserListParam);
        } else {
            availableUserList = new JSONObject();
            availableUserList.put(UM_FIRST_RESULT, 0);
            availableUserList.put(UM_USER_NAME, (Object)"");
        }
        return availableUserList;
    }

    private JSONObject getAssignedUserList(RequestContext context) throws Exception {
        JSONObject assignedUserList;
        String assignedUserListParam = context.getRequestParameters().get(RM_ASSIGNED_USER_LIST);
        if (assignedUserListParam != null && assignedUserListParam.length() > 0) {
            assignedUserList = new JSONObject(assignedUserListParam);
        } else {
            assignedUserList = new JSONObject();
            assignedUserList.put(UM_FIRST_RESULT, 0);
            assignedUserList.put(UM_USER_NAME, (Object)"");
        }
        return assignedUserList;
    }

    private UsersOperationResult getUsersOperationResult(RequestContext context, String roleName) throws Exception {
        UsersOperationResult usersOperationResult = (UsersOperationResult)this.getSession(context).get(RM_ROLE_USERS);
        if (usersOperationResult == null || !usersOperationResult.getRoleName().equals(roleName)) {
            usersOperationResult = new UsersOperationResult(roleName);
            this.setUsersOperationResult(context, usersOperationResult);
        }
        return usersOperationResult;
    }

    private void setUsersOperationResult(RequestContext context, UsersOperationResult usersOperationResult) throws Exception {
        if (usersOperationResult != null) {
            this.getSession(context).put(RM_ROLE_USERS, usersOperationResult);
        }
    }

    private int getFirstResult(RequestContext context) {
        String firstResult = this.getDecodedRequestParameter(context, UM_FIRST_RESULT);
        return firstResult != null ? Integer.valueOf(firstResult) : 0;
    }
}

