/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResourceTypeMappingAction
extends MultiAction
implements MessageSourceAware {
    private static Logger logger = Logger.getLogger(ResourceTypeMappingAction.class);
    private static final String RESOLVED_TYPE_SEPARATOR = "!";
    private MessageSource messageSource;
    private RepositoryService repositoryService;
    private Map<String, Object> typeToActionBean;
    private String resourceUriAttributeName;
    private String resourceUriResolvedTypeAttributeName = "resourceUriResolvedType";
    private EngineService engineService;

    public Event doPreExecute(RequestContext context) {
        String resourceUri = context.getFlowScope().getRequiredString(this.resourceUriAttributeName);
        Object targetAction = this.getCachedType(context, resourceUri);
        if (targetAction == null) {
            Resource resource = this.repositoryService.getResource(this.engineService.getRuntimeExecutionContext(), resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            String resourceType = resource.getResourceType();
            targetAction = this.typeToActionBean.get(resourceType);
            if (targetAction == null) {
                String typeLabel = this.messageSource.getMessage("resource." + resourceType + ".label", null, LocaleContextHolder.getLocale());
                throw new JSException("jsexception.unexpected.resource.type.at.uri", new Object[]{typeLabel, resourceUri});
            }
            this.cacheType(context, resourceUri, resourceType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found repository type " + resourceType + " for " + resourceUri));
            }
        }
        this.setTarget(targetAction);
        return null;
    }

    protected Object getCachedType(RequestContext context, String resourceUri) {
        String resolvedType;
        String resourceUriPrefix;
        Object targetAction = null;
        String resolvedTypeAttr = context.getFlowScope().getString(this.resourceUriResolvedTypeAttributeName);
        if (resolvedTypeAttr != null && resolvedTypeAttr.startsWith(resourceUriPrefix = resourceUri + RESOLVED_TYPE_SEPARATOR) && (targetAction = this.typeToActionBean.get(resolvedType = resolvedTypeAttr.substring(resourceUriPrefix.length()))) != null && logger.isDebugEnabled()) {
            logger.debug((Object)("found cached resolved type " + resolvedType + " for " + resourceUri));
        }
        return targetAction;
    }

    protected void cacheType(RequestContext context, String resourceUri, String resourceType) {
        String resolvedType = resourceUri + RESOLVED_TYPE_SEPARATOR + resourceType;
        context.getFlowScope().put(this.resourceUriResolvedTypeAttributeName, (Object)resolvedType);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setTypeToActionBean(Map<String, Object> typeToActionBean) {
        this.typeToActionBean = typeToActionBean;
    }

    public Map<String, Object> getTypeToActionBean() {
        return this.typeToActionBean;
    }

    public void setResourceUriAttributeName(String resourceUriAttributeName) {
        this.resourceUriAttributeName = resourceUriAttributeName;
    }

    public String getResourceUriAttributeName() {
        return this.resourceUriAttributeName;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public String getResourceUriResolvedTypeAttributeName() {
        return this.resourceUriResolvedTypeAttributeName;
    }

    public void setResourceUriResolvedTypeAttributeName(String resourceUriResolvedTypeAttributeName) {
        this.resourceUriResolvedTypeAttributeName = resourceUriResolvedTypeAttributeName;
    }
}

