/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RepositoryAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final Class[] RESOURCE_TYPES = new Class[]{ReportUnit.class, OlapUnit.class, ContentResource.class};
    private RepositoryService repository;
    private String flowAttributeFolder;
    private MessageSource messages;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public Event initAction(RequestContext context) {
        String folderURI = context.getRequestParameters().get("folder");
        if (folderURI == null) {
            folderURI = context.getFlowScope().getString(this.getFlowAttributeFolder());
            if (folderURI == null) {
                folderURI = "/";
            }
        } else {
            context.getFlowScope().put(this.getFlowAttributeFolder(), (Object)folderURI);
        }
        List pathFolders = this.getPathFolders(folderURI);
        context.getRequestScope().put("pathFolders", (Object)pathFolders);
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext(context);
        List folders = this.repository.getSubFolders(executionContext, folderURI);
        Class[] resourceTypes = this.getResourceTypes();
        FilterCriteria[] criterias = new FilterCriteria[resourceTypes.length];
        for (int i = 0; i < resourceTypes.length; ++i) {
            FilterCriteria criteria = FilterCriteria.createFilter((Class)resourceTypes[i]);
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            criterias[i] = criteria;
        }
        List resourceLookups = this.repository.loadResourcesList(executionContext, criterias);
        ArrayList resources = new ArrayList();
        resources.addAll(folders);
        resources.addAll(resourceLookups);
        context.getRequestScope().put("resources", resources);
        return this.success();
    }

    protected Class[] getResourceTypes() {
        return RESOURCE_TYPES;
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    protected List getPathFolders(String uri) {
        ArrayList<FolderImpl> pathFolders = new ArrayList<FolderImpl>();
        FolderImpl parentFolder = null;
        StringTokenizer tkzer = new StringTokenizer(uri, "/", false);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            FolderImpl folder = new FolderImpl();
            folder.setName(token);
            folder.setParentFolder(parentFolder);
            pathFolders.add(folder);
            parentFolder = folder;
        }
        return pathFolders;
    }

    public String getFlowAttributeFolder() {
        return this.flowAttributeFolder;
    }

    public void setFlowAttributeFolder(String flowAttributeFolder) {
        this.flowAttributeFolder = flowAttributeFolder;
    }
}

