/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.OdsExportParametersBean;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import org.springframework.webflow.execution.RequestContext;

public class ReportOdsExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "odsExportParams";
    private OdsExportParametersBean exportParameters;

    public OdsExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    @Override
    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }

    public void setExportParameters(OdsExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    @Override
    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException, JSException {
        JROdsExporter exporter = new JROdsExporter(this.getJasperReportsContext());
        exporter.setParameters(baseParameters);
        OdsExportParametersBean exportParams = (OdsExportParametersBean)this.getExportParameters(context);
        if (exportParams.isOverrideReportHints()) {
            exporter.setParameter(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, (Object)Boolean.TRUE);
        }
        if (exportParams.getOnePagePerSheet() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
        }
        if (exportParams.getDetectCellType() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
        }
        if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
        }
        if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
        }
        if (exportParams.getWhitePageBackground() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
        }
        if (exportParams.getIgnoreGraphics() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
        }
        if (exportParams.getCollapseRowSpan() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
        }
        if (exportParams.getIgnoreCellBorder() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
        }
        if (exportParams.getFontSizeFixEnabled() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
        }
        if (exportParams.getMaximumRowsPerSheet() != null) {
            exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
        }
        if (exportParams.getXlsFormatPatternsMap() != null && !exportParams.getXlsFormatPatternsMap().isEmpty()) {
            exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
        }
        exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            if (e.getCause() instanceof RowsExceededException) {
                throw new JSException("jsexception.too.many.data.rows");
            }
            throw e;
        }
    }

    @Override
    protected String getContentType(RequestContext context) {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getFilename(context) + "\"");
    }

    @Override
    protected String getDownloadFileExtension() {
        return "ods";
    }
}

