/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.util.DateUtils;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LogEventAction
extends FormAction {
    private static final String ATTRIBUTE_AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private static final String ATTRIBUTE_MESSAGE_FILTER = "messageFilter";
    private static final String ATTRIBUTE_MESSAGE = "message";
    private static final String PARAMETER_SELECTED_IDS = "selectedIds";
    private static final String PARAMETER_ID = "id";
    private LoggingService loggingService;
    private MessageSource messages;
    private ConfigurationBean configurationBean;

    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }

    public Event messages(RequestContext context) throws Exception {
        try {
            String messageFilterName = (String)context.getConversationScope().get(ATTRIBUTE_MESSAGE_FILTER);
            List events = MessageFilter.ALL.name().equals(messageFilterName) ? this.loggingService.getUserEvents(null) : (MessageFilter.UNREAD.name().equals(messageFilterName) ? this.loggingService.getUnreadEvents(null) : this.loggingService.getUserEvents(null));
            context.getRequestScope().put(ATTRIBUTE_AJAX_RESPONSE_MODEL, (Object)this.createJSONResponse(this.toJsonMessages(events, false), true));
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(ATTRIBUTE_MESSAGE, (Object)e.toString());
            context.getRequestScope().put(ATTRIBUTE_AJAX_RESPONSE_MODEL, (Object)this.createJSONResponse(jsonObject, true));
        }
        return this.success();
    }

    public JSONObject createJSONResponse(Object json, boolean success) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", (Object)(success ? "OK" : "ERROR"));
        jsonObject.put("data", json);
        return jsonObject;
    }

    private JSONArray toJsonMessages(List<LogEvent> events, boolean detailed) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (LogEvent logEvent : events) {
            jsonArray.put((Object)this.toJsonMessage(logEvent, detailed));
        }
        return jsonArray;
    }

    private JSONObject toJsonMessage(LogEvent logEvent, boolean detailed) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PARAMETER_ID, logEvent.getId());
        jsonObject.put("date", (Object)this.getFormattedDate(logEvent.getOccurrenceDate()));
        jsonObject.put("timestamp", (Object)new SimpleDateFormat(this.configurationBean.getTimestampFormat()).format(logEvent.getOccurrenceDate()));
        jsonObject.put("subject", (Object)this.messages.getMessage(logEvent.getMessageCode(), null, LocaleContextHolder.getLocale()));
        jsonObject.put("type", (Object)this.messages.getMessage("eventType." + logEvent.getType() + ".label", null, LocaleContextHolder.getLocale()));
        jsonObject.put("component", (Object)this.messages.getMessage("event.component." + logEvent.getComponent(), null, LocaleContextHolder.getLocale()));
        if (detailed) {
            jsonObject.put(ATTRIBUTE_MESSAGE, (Object)logEvent.getText());
        }
        jsonObject.put("isRead", logEvent.getState() == 2);
        return jsonObject;
    }

    private String getFormattedDate(Date date) {
        String formattedDate = new SimpleDateFormat(this.configurationBean.getDateFormat()).format(date);
        if (DateUtils.isToday((Date)date)) {
            formattedDate = this.messages.getMessage("event.date.today", null, formattedDate, LocaleContextHolder.getLocale());
        } else if (DateUtils.isYesterday((Date)date)) {
            formattedDate = this.messages.getMessage("event.date.yesterday", null, formattedDate, LocaleContextHolder.getLocale());
        } else if (DateUtils.isThisYear((Date)date)) {
            formattedDate = new SimpleDateFormat(this.configurationBean.getCurrentYearDateFormat()).format(date);
        }
        return formattedDate;
    }

    public Event changeEventsType(RequestContext context) throws Exception {
        String messageFilterName = context.getRequestParameters().get(ATTRIBUTE_MESSAGE_FILTER);
        context.getConversationScope().put(ATTRIBUTE_MESSAGE_FILTER, (Object)messageFilterName);
        return this.success();
    }

    private long[] getIds(RequestContext context) {
        if (context.getRequestParameters().contains(PARAMETER_SELECTED_IDS)) {
            Long[] idArray = (Long[])context.getRequestParameters().getArray(PARAMETER_SELECTED_IDS, Long.class);
            long[] ids = new long[idArray.length];
            for (int i = 0; i < idArray.length; ++i) {
                ids[i] = idArray[i];
            }
            return ids;
        }
        return null;
    }

    public Event delete(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            this.loggingService.delete(null, ids);
        }
        return this.success();
    }

    public Event markAsRead(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            for (long id : ids) {
                LogEvent event = this.loggingService.getLogEvent(null, id);
                if (event.getState() == 2) continue;
                event.setState((byte)2);
                this.loggingService.update(event);
            }
        }
        return this.success();
    }

    public Event markAsUnread(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            for (long id : ids) {
                LogEvent event = this.loggingService.getLogEvent(null, id);
                if (event.getState() == 1) continue;
                event.setState((byte)1);
                this.loggingService.update(event);
            }
        }
        return this.success();
    }

    public Event setupMessageDetail(RequestContext context) throws Exception {
        String id = context.getRequestParameters().get(PARAMETER_ID);
        try {
            LogEvent event = this.loggingService.getLogEvent(null, Long.parseLong(id));
            if (event.getState() == 1) {
                event.setState((byte)2);
                this.loggingService.update(event);
            }
            context.getRequestScope().put(ATTRIBUTE_MESSAGE, (Object)this.toJsonMessage(event, true));
            return this.success();
        }
        catch (NumberFormatException e) {
            return this.error();
        }
    }

    static enum MessageFilter {
        ALL,
        UNREAD;

    }
}

