/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.tonbeller.jpivot.chart.ChartComponent;
import com.tonbeller.jpivot.print.PrintComponent;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.w3c.dom.Document;

public class OlapPrint
extends HttpServlet {
    private static final Log logger = LogFactory.getLog(OlapPrint.class);
    private static int XLS = 0;
    private static int PDF = 1;
    String filename;
    Resources resources = Resources.instance(OlapPrint.class);
    FopFactory fopFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.fopFactory = FopFactory.newInstance();
            String fopConfigPath = config.getServletContext().getRealPath("/WEB-INF/jpivot/print/userconfig-0.95.xml");
            this.fopFactory.setUserConfig(new File(fopConfigPath));
            String fontBaseDir = config.getServletContext().getRealPath("/WEB-INF/jpivot/print/");
            this.fopFactory.setFontBaseURL("file:///" + fontBaseDir);
            this.fopFactory.setStrictValidation(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)"FOP user config file not loaded");
        }
    }

    public void destroy() {
    }

    protected void processRequest(RequestContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        HttpSession session = request.getSession();
        String type = request.getParameter("type");
        int identifiedType = -1;
        boolean xslCache = true;
        String view = request.getParameter("view");
        if (view == null || type == null) {
            throw new ServletException("view and type parameters not supplied");
        }
        ServletOutputStream outStream = response.getOutputStream();
        PrintWriter out = null;
        try {
            String xslUri = null;
            if (type.equalsIgnoreCase("XLS")) {
                xslUri = "/WEB-INF/jpivot/table/xls_mdxtable.xsl";
                RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                response.setContentType("application/vnd.ms-excel");
                this.filename = "xls_export.xls";
                identifiedType = XLS;
            } else if (type.equalsIgnoreCase("PDF")) {
                xslUri = "/WEB-INF/jpivot/table/fo_mdxtable.xsl";
                RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                response.setContentType("application/pdf");
                this.filename = "xls_export.pdf";
                identifiedType = PDF;
            } else {
                throw new ServletException("Unknown file type: " + type);
            }
            String tableRef = view + "/table";
            String chartRef = view + "/chart";
            String printRef = view + "/print";
            TableComponent table = (TableComponent)context.getModelReference(tableRef);
            if (table == null) {
                return;
            }
            Map parameters = this.getPrintParameters(printRef, context);
            parameters.putAll(this.getChartParameters(chartRef, request));
            parameters.put("context", context.getRequest().getContextPath());
            response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
            table.setDirty(true);
            Document document = table.render(context);
            table.setDirty(true);
            DOMSource source = new DOMSource(document);
            Transformer transformer = XmlUtils.getTransformer((HttpSession)session, (String)xslUri, (boolean)xslCache);
            for (String name : parameters.keySet()) {
                Object value = parameters.get(name);
                transformer.setParameter(name, value);
            }
            if (identifiedType == XLS) {
                logger.debug((Object)"Creating XLS");
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                transformer.transform(source, result);
                sw.flush();
                response.setContentLength(sw.toString().length());
                out = new PrintWriter((OutputStream)outStream);
                out.write(sw.toString());
                RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
            } else {
                logger.debug((Object)"Creating PDF");
                logger.debug((Object)this.resources.getString("jpivot.PrintServlet.message.encoding", new Object[]{this.resources.getCharacterEncoding()}));
                FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
                Fop fop = this.fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)outStream);
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(source, res);
                RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception ex) {}
            }
            if (outStream != null) {
                try {
                    outStream.flush();
                    outStream.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private Map getPrintParameters(String printRef, RequestContext context) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PrintComponent printConfig = (PrintComponent)context.getModelReference(printRef);
        if (printConfig == null) {
            return parameters;
        }
        if (printConfig.isSetTableWidth()) {
            printConfig.getClass();
            parameters.put("tableWidth", new Double(printConfig.getTableWidth()));
        }
        if (printConfig.getReportTitle().trim().length() != 0) {
            printConfig.getClass();
            parameters.put("reportTitle", printConfig.getReportTitle().trim());
        }
        printConfig.getClass();
        parameters.put("pageOrientation", printConfig.getPageOrientation());
        printConfig.getClass();
        parameters.put("paper.type", printConfig.getPaperType());
        if (printConfig.getPaperType().equals(this.resources.getString("jsp.wcf.print.custom"))) {
            printConfig.getClass();
            parameters.put("pageWidth", new Double(printConfig.getPageWidth()));
            printConfig.getClass();
            parameters.put("pageHeight", new Double(printConfig.getPageHeight()));
        }
        printConfig.getClass();
        parameters.put("chartPageBreak", new Boolean(printConfig.isChartPageBreak()));
        return parameters;
    }

    private Map getChartParameters(String chartRef, HttpServletRequest request) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ChartComponent chart = (ChartComponent)request.getSession().getAttribute(chartRef);
        if (chart == null || !chart.isVisible()) {
            return parameters;
        }
        String host = request.getServerName();
        int port = request.getServerPort();
        String location = request.getContextPath();
        String scheme = request.getScheme();
        String chartServlet = scheme + "://" + host + ":" + port + location + "/GetChart";
        parameters.put("chartimage", chartServlet + "?filename=" + chart.getFilename());
        parameters.put("chartheight", new Integer(chart.getChartHeight()));
        parameters.put("chartwidth", new Integer(chart.getChartWidth()));
        return parameters;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContext context = RequestContextFactoryFinder.createContext((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
        try {
            this.processRequest(context);
        }
        finally {
            context.invalidate();
        }
    }

    public String getServletInfo() {
        return "Export OLAP table to Excel or PDF";
    }
}

