/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.wcf.table.EditableTableComponent;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSVServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(CSVServlet.class);
    protected static final String MIME_TYPE = "text/comma-separated-values";
    protected static final String HTML_TYPE = "text/html";
    protected static final String SEP = ",";
    protected static final String NULL_VALUE = "";
    protected static final String NEWLINE = "\r\n";
    private Context jndiContext;

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            resp.setContentType(MIME_TYPE);
            resp.setHeader("Pragma", NULL_VALUE);
            resp.setHeader("Cache-Control", "no-store");
            PrintWriter out = resp.getWriter();
            this.printQuery(this.getDrillThroughSQL(req), this.getConnection(req), out);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    private MondrianDrillThroughTableModel getDrillThroughModel(HttpServletRequest req) {
        HttpSession session = req.getSession();
        OlapModel olapModel = (OlapModel)session.getAttribute("olapModel");
        Model mdl = ((OlapModelDecorator)olapModel).getRootModel();
        String currentView = (String)session.getAttribute("currentView");
        if (mdl instanceof MondrianModel) {
            try {
                EditableTableComponent et;
                if (currentView != null && (et = (EditableTableComponent)session.getAttribute(currentView + ".drillthroughtable")) != null) {
                    return (MondrianDrillThroughTableModel)et.getModel();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e.getStackTrace());
            }
        }
        return null;
    }

    private Connection getConnection(HttpServletRequest req) throws SQLException {
        MondrianDrillThroughTableModel model = this.getDrillThroughModel(req);
        if (model.getDataSourceName() == null) {
            return DriverManager.getConnection(model.getJdbcUrl(), model.getJdbcUser(), model.getJdbcPassword());
        }
        return this.getDataSource(req).getConnection();
    }

    private DataSource getDataSource(HttpServletRequest req) {
        MondrianDrillThroughTableModel model = this.getDrillThroughModel(req);
        String dataSourceName = model.getDataSourceName();
        try {
            return (DataSource)this.getJndiContext().lookup(dataSourceName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
    }

    private Context getJndiContext() throws NamingException {
        if (this.jndiContext == null) {
            this.jndiContext = new InitialContext();
        }
        return this.jndiContext;
    }

    private String getDrillThroughSQL(HttpServletRequest req) {
        MondrianDrillThroughTableModel model = this.getDrillThroughModel(req);
        return model.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printQuery(String sqlQuery, Connection conn, PrintWriter out) {
        log.info((Object)("drill-through SQL = " + sqlQuery));
        try {
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery(sqlQuery);
            this.printCSV(rs, out);
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                log.error((Object)sqle);
            }
        }
    }

    private void printCSV(ResultSet rs, PrintWriter out) throws Exception {
        int i;
        ResultSetMetaData md = rs.getMetaData();
        int numCols = md.getColumnCount();
        for (i = 1; i < numCols; ++i) {
            out.write(this.quoteString(md.getColumnName(i)));
            out.write(SEP);
        }
        out.write(this.quoteString(md.getColumnName(numCols)));
        out.write(NEWLINE);
        while (rs.next()) {
            for (i = 1; i < numCols; ++i) {
                out.write(this.quoteString(NULL_VALUE + rs.getObject(i)));
                out.write(SEP);
            }
            out.write(this.quoteString(NULL_VALUE + rs.getObject(numCols)));
            out.write(NEWLINE);
        }
    }

    private String quoteString(String s) {
        s = s.replaceAll("\"", "\"\"");
        s = "\"" + s + "\"";
        return s;
    }
}

