/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.BinlogDumpException;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.Protocol;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.ServerStatus;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.CompressOutputStream;
import org.mariadb.jdbc.internal.common.packet.DecompressInputStream;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.LocalInfilePacket;
import org.mariadb.jdbc.internal.common.packet.OKPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacketFactory;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;
import org.mariadb.jdbc.internal.common.packet.SyncPacketFetcher;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.common.packet.commands.ClosePacket;
import org.mariadb.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.mariadb.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.mysql.DummyX509TrustManager;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLServerCapabilities;
import org.mariadb.jdbc.internal.mysql.packet.MySQLGreetingReadPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.AbbreviatedMySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLBinlogDumpPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLPingPacket;

public class MySQLProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(MySQLProtocol.class.getName());
    private boolean connected = false;
    private Socket socket;
    private PacketOutputStream writer;
    private String version;
    private boolean readOnly = false;
    private String database;
    private final String username;
    private final String password;
    private int maxRows;
    private List<Query> batchList;
    private SyncPacketFetcher packetFetcher;
    private final Properties info;
    private long serverThreadId;
    public boolean moreResults = false;
    public boolean hasWarnings = false;
    public StreamingSelectResult activeResult = null;
    public int datatypeMappingFlags;
    public Set<ServerStatus> serverStatus;
    JDBCUrl jdbcUrl;
    HostAddress currentHost;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    boolean hostFailed;
    long failTimestamp;
    int reconnectCount;
    int queriesSinceFailover;
    private boolean autoReconnect = false;
    private int maxReconnects = 3;
    int retriesAllDown = 120;
    int initialTimeout = 2;
    boolean roundRobinLoadBalance = false;
    int queriesBeforeRetryMaster = 50;
    int secondsBeforeRetryMaster = 30;

    private SSLSocketFactory getSSLSocketFactory(boolean trustServerCertificate) throws QueryException {
        if (!trustServerCertificate) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] m = new X509TrustManager[]{new DummyX509TrustManager()};
            sslContext.init(null, m, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage());
        }
    }

    public MySQLProtocol(JDBCUrl url, String username, String password, Properties info) throws QueryException {
        this.info = info;
        this.jdbcUrl = url;
        this.database = this.jdbcUrl.getDatabase() == null ? "" : this.jdbcUrl.getDatabase();
        this.username = username == null ? "" : username;
        this.password = password == null ? "" : password;
        String logLevel = info.getProperty("MySQLProtocolLogLevel");
        if (logLevel != null) {
            log.setLevel(Level.parse(logLevel));
        } else {
            log.setLevel(Level.OFF);
        }
        this.batchList = new ArrayList<Query>();
        this.setDatatypeMappingFlags();
        this.parseHAOptions();
        this.connect();
    }

    private void parseHAOptions() {
        String s = this.info.getProperty("autoReconnect");
        if (s != null && s.equals("true")) {
            this.autoReconnect = true;
        }
        if ((s = this.info.getProperty("maxReconnects")) != null) {
            this.maxReconnects = Integer.parseInt(s);
        }
        if ((s = this.info.getProperty("queriesBeforeRetryMaster")) != null) {
            this.queriesBeforeRetryMaster = Integer.parseInt(s);
        }
        if ((s = this.info.getProperty("secondsBeforeRetryMaster")) != null) {
            this.secondsBeforeRetryMaster = Integer.parseInt(s);
        }
    }

    void connect(String host, int port) throws QueryException, IOException {
        SocketFactory socketFactory = null;
        String socketFactoryName = this.info.getProperty("socketFactory");
        if (socketFactoryName != null) {
            try {
                socketFactory = (SocketFactory)Class.forName(socketFactoryName).newInstance();
            }
            catch (Exception sfex) {
                log.info("Failed to create socket factory " + socketFactoryName);
                socketFactory = SocketFactory.getDefault();
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        String connectTimeoutString = this.info.getProperty("connectTimeout");
        Integer connectTimeout = null;
        if (connectTimeoutString != null) {
            try {
                connectTimeout = Integer.valueOf(connectTimeoutString);
            }
            catch (Exception e) {
                connectTimeout = null;
            }
        }
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        this.socket = socketFactory.createSocket();
        try {
            String value = this.info.getProperty("tcpNoDelay", "false");
            if (value.equalsIgnoreCase("true")) {
                this.socket.setTcpNoDelay(true);
            }
            if ((value = this.info.getProperty("tcpKeepAlive", "false")).equalsIgnoreCase("true")) {
                this.socket.setKeepAlive(true);
            }
            if ((value = this.info.getProperty("tcpRcvBuf")) != null) {
                this.socket.setReceiveBufferSize(Integer.parseInt(value));
            }
            if ((value = this.info.getProperty("tcpSndBuf")) != null) {
                this.socket.setSendBufferSize(Integer.parseInt(value));
            }
            if ((value = this.info.getProperty("tcpAbortiveClose", "false")).equalsIgnoreCase("true")) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            log.finest("Failed to set socket option: " + e.getLocalizedMessage());
        }
        String localHost = this.info.getProperty("localSocketAddress");
        if (localHost != null) {
            InetSocketAddress localAddress = new InetSocketAddress(localHost, 0);
            this.socket.bind(localAddress);
        }
        if (connectTimeout != null) {
            this.socket.connect(sockAddr, connectTimeout * 1000);
        } else {
            this.socket.connect(sockAddr);
        }
        String socketTimeoutString = this.info.getProperty("socketTimeout");
        Integer socketTimeout = null;
        if (socketTimeoutString != null) {
            try {
                socketTimeout = Integer.valueOf(socketTimeoutString);
            }
            catch (Exception e) {
                socketTimeout = null;
            }
        }
        if (socketTimeout != null) {
            this.socket.setSoTimeout(socketTimeout);
        }
        try {
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new SyncPacketFetcher(reader);
            this.writer = new PacketOutputStream(this.socket.getOutputStream());
            RawPacket packet = this.packetFetcher.getRawPacket();
            if (ReadUtil.isErrorPacket(packet)) {
                reader.close();
                ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(packet);
                throw new QueryException(errorPacket.getMessage());
            }
            MySQLGreetingReadPacket greetingPacket = new MySQLGreetingReadPacket(packet);
            this.serverThreadId = greetingPacket.getServerThreadID();
            boolean useCompression = false;
            log.finest("Got greeting packet");
            this.version = greetingPacket.getServerVersion();
            this.parseVersion();
            byte packetSeq = 1;
            EnumSet<MySQLServerCapabilities[]> capabilities = EnumSet.of(MySQLServerCapabilities.LONG_PASSWORD, new MySQLServerCapabilities[]{MySQLServerCapabilities.IGNORE_SPACE, MySQLServerCapabilities.CLIENT_PROTOCOL_41, MySQLServerCapabilities.TRANSACTIONS, MySQLServerCapabilities.SECURE_CONNECTION, MySQLServerCapabilities.LOCAL_FILES, MySQLServerCapabilities.MULTI_RESULTS, MySQLServerCapabilities.FOUND_ROWS});
            if (this.info.getProperty("allowMultiQueries") != null) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.MULTI_STATEMENTS);
            }
            if (this.info.getProperty("useCompression") != null) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.COMPRESS);
                useCompression = true;
            }
            if (this.info.getProperty("interactiveClient") != null) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.CLIENT_INTERACTIVE);
            }
            if (this.info.getProperty("useSSL") != null && greetingPacket.getServerCapabilities().contains((Object)MySQLServerCapabilities.SSL)) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.SSL);
                AbbreviatedMySQLClientAuthPacket amcap = new AbbreviatedMySQLClientAuthPacket(capabilities);
                amcap.send(this.writer);
                boolean trustServerCertificate = this.info.getProperty("trustServerCertificate") != null;
                SSLSocketFactory f = this.getSSLSocketFactory(trustServerCertificate);
                SSLSocket sslSocket = (SSLSocket)f.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), false);
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new PacketOutputStream(this.socket.getOutputStream());
                reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
                this.packetFetcher = new SyncPacketFetcher(reader);
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.info.getProperty("useSSL") != null) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            if (this.database != null && !this.createDB()) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.CONNECT_WITH_DB);
            }
            MySQLClientAuthPacket cap = new MySQLClientAuthPacket(this.username, this.password, this.database, capabilities, greetingPacket.getSeed(), packetSeq);
            cap.send(this.writer);
            log.finest("Sending auth packet");
            RawPacket rp = this.packetFetcher.getRawPacket();
            if ((rp.getByteBuffer().get(0) & 0xFF) == 254) {
                MySQLClientOldPasswordAuthPacket oldPassPacket = new MySQLClientOldPasswordAuthPacket(this.password, Utils.copyWithLength(greetingPacket.getSeed(), 8), rp.getPacketSeq() + 1);
                oldPassPacket.send(this.writer);
                rp = this.packetFetcher.getRawPacket();
            }
            if (useCompression) {
                this.writer = new PacketOutputStream(new CompressOutputStream(this.socket.getOutputStream()));
                this.packetFetcher = new SyncPacketFetcher(new DecompressInputStream(this.socket.getInputStream()));
            }
            this.checkErrorPacket(rp);
            ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
            OKPacket ok = (OKPacket)resultPacket;
            this.serverStatus = ok.getServerStatus();
            if (!this.serverStatus.contains((Object)ServerStatus.AUTOCOMMIT)) {
                this.executeQuery(new MySQLQuery("set autocommit=1"));
            }
            if (this.createDB()) {
                this.executeQuery(new MySQLQuery("CREATE DATABASE IF NOT EXISTS " + this.database));
                this.executeQuery(new MySQLQuery("USE " + this.database));
            }
            this.activeResult = null;
            this.moreResults = false;
            this.hasWarnings = false;
            this.connected = true;
            this.hostFailed = false;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect to " + host + ":" + port + ": " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    void checkErrorPacket(RawPacket rp) throws QueryException {
        if (rp.getByteBuffer().get(0) == -1) {
            ErrorPacket ep = new ErrorPacket(rp);
            String message = ep.getMessage();
            throw new QueryException("Could not connect: " + message);
        }
    }

    void readEOFPacket() throws QueryException, IOException {
        RawPacket rp = this.packetFetcher.getRawPacket();
        this.checkErrorPacket(rp);
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
        if (resultPacket.getResultType() != ResultPacket.ResultType.EOF) {
            throw new QueryException("Unexpected packet type " + (Object)((Object)resultPacket.getResultType()) + "insted of EOF");
        }
        EOFPacket eof = (EOFPacket)resultPacket;
        this.hasWarnings = eof.getWarningCount() > 0;
        this.serverStatus = eof.getStatusFlags();
    }

    void readOKPacket() throws QueryException, IOException {
        RawPacket rp = this.packetFetcher.getRawPacket();
        this.checkErrorPacket(rp);
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
        if (resultPacket.getResultType() != ResultPacket.ResultType.OK) {
            throw new QueryException("Unexpected packet type " + (Object)((Object)resultPacket.getResultType()) + "insted of OK");
        }
        OKPacket ok = (OKPacket)resultPacket;
        this.hasWarnings = ok.getWarnings() > 0;
        this.serverStatus = ok.getServerStatus();
    }

    public PrepareResult prepare(String sql) throws QueryException {
        try {
            this.writer.startPacket(0);
            this.writer.write(22);
            this.writer.write(sql.getBytes("UTF8"));
            this.writer.finishPacket();
            RawPacket rp = this.packetFetcher.getRawPacket();
            this.checkErrorPacket(rp);
            byte b = rp.getByteBuffer().get(0);
            if (b == 0) {
                Reader r = new Reader(rp);
                r.readByte();
                int statementId = r.readInt();
                int numColumns = r.readShort();
                int numParams = r.readShort();
                r.readByte();
                this.hasWarnings = r.readShort() > 0;
                MySQLColumnInformation[] columns = new MySQLColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                MySQLColumnInformation[] params = new MySQLColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                return new PrepareResult(statementId, columns, params);
            }
            throw new QueryException("Unexpected packet returned by server, first byte " + b);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    public synchronized void closePreparedStatement(int statementId) throws QueryException {
        try {
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.write(statementId);
            this.writer.finishPacket();
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    public void setHostFailed() {
        this.hostFailed = true;
        this.failTimestamp = System.currentTimeMillis();
    }

    public boolean shouldReconnect() {
        return !this.inTransaction() && this.hostFailed && this.autoReconnect && this.reconnectCount < this.maxReconnects;
    }

    public boolean getAutocommit() {
        return this.serverStatus.contains((Object)ServerStatus.AUTOCOMMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectToMaster() throws IOException, QueryException {
        SyncPacketFetcher saveFetcher = this.packetFetcher;
        PacketOutputStream saveWriter = this.writer;
        Socket saveSocket = this.socket;
        HostAddress[] addrs = this.jdbcUrl.getHostAddresses();
        boolean success = false;
        try {
            this.connect(addrs[0].host, addrs[0].port);
            try {
                MySQLProtocol.close(saveFetcher, saveWriter, saveSocket);
            }
            catch (Exception e) {
                // empty catch block
            }
            success = true;
        }
        finally {
            if (!success) {
                this.failTimestamp = System.currentTimeMillis();
                this.queriesSinceFailover = 0;
                this.packetFetcher = saveFetcher;
                this.writer = saveWriter;
                this.socket = saveSocket;
            }
        }
    }

    public void connect() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        HostAddress[] addrs = this.jdbcUrl.getHostAddresses();
        for (int i = 0; i < addrs.length; ++i) {
            this.currentHost = addrs[i];
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (IOException e) {
                if (i != addrs.length - 1) continue;
                throw new QueryException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
    }

    public boolean isMasterConnection() {
        return this.currentHost == this.jdbcUrl.getHostAddresses()[0];
    }

    public boolean shouldTryFailback() {
        if (this.isMasterConnection()) {
            return false;
        }
        if (this.inTransaction()) {
            return false;
        }
        if (this.reconnectCount >= this.maxReconnects) {
            return false;
        }
        long now = System.currentTimeMillis();
        if ((now - this.failTimestamp) / 1000L > (long)this.secondsBeforeRetryMaster) {
            return true;
        }
        return this.queriesSinceFailover > this.queriesBeforeRetryMaster;
    }

    public boolean inTransaction() {
        if (this.serverStatus != null) {
            return this.serverStatus.contains((Object)ServerStatus.IN_TRANSACTION);
        }
        return false;
    }

    private void setDatatypeMappingFlags() {
        this.datatypeMappingFlags = 0;
        String tinyInt1isBit = this.info.getProperty("tinyInt1isBit");
        String yearIsDateType = this.info.getProperty("yearIsDateType");
        if (tinyInt1isBit == null || tinyInt1isBit.equals("1") || tinyInt1isBit.equals("true")) {
            this.datatypeMappingFlags |= 1;
        }
        if (yearIsDateType == null || yearIsDateType.equals("1") || yearIsDateType.equals("true")) {
            this.datatypeMappingFlags |= 2;
        }
    }

    public Properties getInfo() {
        return this.info;
    }

    void skip() throws IOException, QueryException {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
        while (this.moreResults) {
            this.getMoreResults(true);
        }
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    private static void close(PacketFetcher fetcher, PacketOutputStream packetOutputStream, Socket socket) throws QueryException {
        ClosePacket closePacket = new ClosePacket();
        try {
            closePacket.send(packetOutputStream);
            try {
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            packetOutputStream.close();
            fetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.warning("Could not close socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.skip();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            MySQLProtocol.close(this.packetFetcher, this.writer, this.socket);
        }
        catch (Exception e) {
            log.info("got exception " + e + " while closing connection");
        }
        finally {
            this.connected = false;
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private SelectQueryResult createQueryResult(ResultSetPacket packet, boolean streaming) throws IOException, QueryException {
        StreamingSelectResult streamingResult = StreamingSelectResult.createStreamingSelectResult(packet, this.packetFetcher, this);
        if (streaming) {
            return streamingResult;
        }
        return CachedSelectResult.createCachedSelectResult(streamingResult);
    }

    @Override
    public void selectDB(String database) throws QueryException {
        log.finest("Selecting db " + database);
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not select database: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.database = database;
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public String getHost() {
        return this.currentHost.host;
    }

    @Override
    public int getPort() {
        return this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean ping() throws QueryException {
        MySQLPingPacket pingPacket = new MySQLPingPacket();
        try {
            pingPacket.send(this.writer);
            log.finest("Sent ping packet");
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            return ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
        }
        catch (IOException e) {
            throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery) throws QueryException {
        return this.executeQuery(dQuery, false);
    }

    public QueryResult getResult(Query dQuery, boolean streaming) throws QueryException {
        ResultPacket resultPacket;
        block13: {
            try {
                InputStream is;
                RawPacket rawPacket = this.packetFetcher.getRawPacket();
                resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
                if (resultPacket.getResultType() != ResultPacket.ResultType.LOCALINFILE) break block13;
                LocalInfilePacket localInfilePacket = (LocalInfilePacket)resultPacket;
                log.fine("sending local file " + localInfilePacket.getFileName());
                String localInfile = localInfilePacket.getFileName();
                try {
                    URL u = new URL(localInfile);
                    is = u.openStream();
                }
                catch (IOException ioe) {
                    is = new FileInputStream(localInfile);
                }
                this.writer.sendFile(is, rawPacket.getPacketSeq() + 1);
                is.close();
                rawPacket = this.packetFetcher.getRawPacket();
                resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
            }
            catch (IOException e) {
                throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                this.moreResults = false;
                this.hasWarnings = false;
                ErrorPacket ep = (ErrorPacket)resultPacket;
                if (dQuery != null) {
                    log.warning("Could not execute query " + dQuery + ": " + ((ErrorPacket)resultPacket).getMessage());
                } else {
                    log.warning("Got error from server: " + ((ErrorPacket)resultPacket).getMessage());
                }
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                this.serverStatus = okpacket.getServerStatus();
                this.moreResults = this.serverStatus.contains((Object)ServerStatus.MORE_RESULTS_EXISTS);
                this.hasWarnings = okpacket.getWarnings() > 0;
                UpdateResult updateResult = new UpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.fine("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                this.hasWarnings = false;
                log.fine("SELECT executed, fetching result set");
                ResultSetPacket resultSetPacket = (ResultSetPacket)resultPacket;
                try {
                    return this.createQueryResult(resultSetPacket, streaming);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result..." + (Object)((Object)resultPacket.getResultType()));
        throw new QueryException("Could not parse result", -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState());
    }

    @Override
    public QueryResult executeQuery(Query dQuery, boolean streaming) throws QueryException {
        dQuery.validate();
        log.finest("Executing streamed query: " + dQuery);
        this.moreResults = false;
        StreamedQueryPacket packet = new StreamedQueryPacket(dQuery);
        try {
            packet.send(this.writer);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        if (!this.isMasterConnection()) {
            ++this.queriesSinceFailover;
        }
        return this.getResult(dQuery, streaming);
    }

    @Override
    public void addToBatch(Query dQuery) {
        this.batchList.add(dQuery);
    }

    @Override
    public synchronized List<QueryResult> executeBatch() throws QueryException {
        ArrayList<QueryResult> retList = new ArrayList<QueryResult>(this.batchList.size());
        for (Query query : this.batchList) {
            retList.add(this.executeQuery(query));
        }
        this.clearBatch();
        return retList;
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public List<RawPacket> startBinlogDump(int startPos, String filename) throws BinlogDumpException {
        MySQLBinlogDumpPacket mbdp = new MySQLBinlogDumpPacket(startPos, filename);
        try {
            mbdp.send(this.writer);
            LinkedList<RawPacket> rpList = new LinkedList<RawPacket>();
            while (true) {
                RawPacket rp;
                if (ReadUtil.eofIsNext(rp = this.packetFetcher.getRawPacket())) {
                    return rpList;
                }
                rpList.add(rp);
            }
        }
        catch (IOException e) {
            throw new BinlogDumpException("Could not read binlog", e);
        }
    }

    @Override
    public String getServerVariable(String variable) throws QueryException {
        CachedSelectResult qr = (CachedSelectResult)this.executeQuery(new MySQLQuery("select @@" + variable));
        try {
            if (!qr.next()) {
                throw new QueryException("Could not get variable: " + variable);
            }
        }
        catch (IOException ioe) {
            throw new QueryException(ioe.getMessage(), 0, "HYOOO", ioe);
        }
        try {
            String value = qr.getValueObject(0).getString();
            return value;
        }
        catch (NoSuchColumnException e) {
            throw new QueryException("Could not get variable: " + variable);
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MySQLProtocol copiedProtocol = new MySQLProtocol(this.jdbcUrl, this.username, this.password, this.info);
        copiedProtocol.executeQuery(new MySQLQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public boolean createDB() {
        String alias = this.info.getProperty("createDatabaseIfNotExist");
        return this.info != null && (this.info.getProperty("createDB", "").equalsIgnoreCase("true") || alias != null && alias.equalsIgnoreCase("true"));
    }

    @Override
    public QueryResult getMoreResults(boolean streaming) throws QueryException {
        if (!this.moreResults) {
            return null;
        }
        return this.getResult(null, streaming);
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] b = new byte[bb.remaining()];
        bb.mark();
        bb.get(b);
        bb.reset();
        return MySQLProtocol.hexdump(b, offset);
    }

    @Override
    public boolean hasUnreadData() {
        return this.activeResult != null;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=DEFAULT"));
            } else {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=" + max));
            }
            this.maxRows = max;
        }
    }

    void parseVersion() {
        String[] a = this.version.split("[^0-9]");
        if (a.length > 0) {
            this.majorVersion = Integer.parseInt(a[0]);
        }
        if (a.length > 1) {
            this.minorVersion = Integer.parseInt(a[1]);
        }
        if (a.length > 2) {
            this.patchVersion = Integer.parseInt(a[2]);
        }
    }

    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    public class PrepareResult {
        public int statementId;
        public MySQLColumnInformation[] columns;
        public MySQLColumnInformation[] parameters;

        public PrepareResult(int statementId, MySQLColumnInformation[] columns, MySQLColumnInformation[] parameters) {
            this.statementId = statementId;
            this.columns = columns;
            this.parameters = parameters;
        }
    }
}

