/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import java.util.Set;
import org.mariadb.jdbc.internal.common.ServerStatus;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;

public class EOFPacket
extends ResultPacket {
    private final byte packetSeq;
    private final short warningCount;
    private final Set<ServerStatus> statusFlags;

    public EOFPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.packetSeq = 0;
        reader.readByte();
        this.warningCount = reader.readShort();
        this.statusFlags = ServerStatus.getServerStatusSet(reader.readShort());
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.EOF;
    }

    @Override
    public byte getPacketSeq() {
        return this.packetSeq;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    public Set<ServerStatus> getStatusFlags() {
        return this.statusFlags;
    }

    public String toString() {
        return "EOFPacket{packetSeq=" + this.packetSeq + ", warningCount=" + this.warningCount + ", statusFlags=" + this.statusFlags + '}';
    }
}

