/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import com.tonbeller.wcf.utils.XoplonNS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomUtils {
    static final Random random = new Random();

    public static List getChildElemsByTagName(Element parent, String tagName) {
        ArrayList<Element> retVec = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            if (children.item(i).getNodeType() != 1 || !(child = (Element)children.item(i)).getTagName().equals(tagName)) continue;
            retVec.add(child);
        }
        return retVec;
    }

    public static List getChildElements(Node parent) {
        ArrayList<Node> retVec = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            retVec.add(children.item(i));
        }
        return retVec;
    }

    public static List getChildNodesExceptAttributes(Node parent) {
        ArrayList<Node> retVec = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3 && children.item(i).getNodeType() != 1) continue;
            retVec.add(children.item(i));
        }
        return retVec;
    }

    public static void removeChildElements(Element parent) {
        List v = DomUtils.getChildElements(parent);
        Iterator en = v.iterator();
        while (en.hasNext()) {
            parent.removeChild((Node)en.next());
        }
    }

    public static void removeChildNodesExceptAttributes(Element parent) {
        List v = DomUtils.getChildNodesExceptAttributes(parent);
        Iterator en = v.iterator();
        while (en.hasNext()) {
            parent.removeChild((Node)en.next());
        }
    }

    public static Text setText(Element parent, String text) {
        DomUtils.removeChildNodesExceptAttributes(parent);
        Document doc = parent.getOwnerDocument();
        Text child = doc.createTextNode(text);
        parent.appendChild(child);
        return child;
    }

    public static Element getChildElemByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            if (children.item(i).getNodeType() != 1 || !(child = (Element)children.item(i)).getTagName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    public static Element getChildElemById(Element parent, String id) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            if (children.item(i).getNodeType() != 1 || !XoplonNS.getAttribute(child = (Element)children.item(i), "id").equals(id)) continue;
            return child;
        }
        return null;
    }

    public static Document getDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element appendElement(Element parent, String type) {
        Document doc = parent.getOwnerDocument();
        Element elem = doc.createElement(type);
        parent.appendChild(elem);
        return elem;
    }

    public static Text appendNbsp(Element parent) {
        return DomUtils.appendText(parent, "\u00a0");
    }

    public static Text appendText(Element parent, String text) {
        Document doc = parent.getOwnerDocument();
        Text x = doc.createTextNode(text);
        parent.appendChild(x);
        return x;
    }

    public static synchronized String randomId() {
        return "wcf" + Integer.toHexString(random.nextInt());
    }

    public static synchronized void setRandomSeed(long seed) {
        random.setSeed(seed);
    }

    public static void generateIds(Node root, String attrName) {
        Element e;
        String id;
        if (root.getNodeType() == 1 && ((id = (e = (Element)root).getAttribute(attrName)) == null || id.length() == 0)) {
            e.setAttribute(attrName, DomUtils.randomId());
        }
        NodeList list = root.getChildNodes();
        int N = list.getLength();
        for (int i = 0; i < N; ++i) {
            DomUtils.generateIds(list.item(i), attrName);
        }
    }

    public static void generateIds(Node root) {
        DomUtils.generateIds(root, "id");
    }

    public static Element findElementWithId(String id, Element root) {
        if (id.equals(root.getAttribute("id"))) {
            return root;
        }
        NodeList list = root.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Element child;
            Element found;
            Node n = list.item(i);
            if (n.getNodeType() != 1 || (found = DomUtils.findElementWithId(id, child = (Element)list.item(i))) == null) continue;
            return found;
        }
        return null;
    }

    public static void removeAttribute(Element elem, String name) {
        try {
            elem.removeAttribute(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

