/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tabbed;

import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.form.NodeHandler;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.tabbed.PanelChangeEvent;
import com.tonbeller.wcf.tabbed.PanelChangeListener;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TabbedHandler
implements NodeHandler,
RequestListener {
    private NodeList panels;
    private Dispatcher dispatcher = new DispatcherSupport();
    private static Logger logger = Logger.getLogger(TabbedHandler.class);
    private Controller controller;
    private XmlComponent xmlComponent;
    private ArrayList panelChangeListeners = new ArrayList();
    private Element currentPanel = null;
    private Element tabbed = null;

    public void initialize(RequestContext context, XmlComponent comp, Element tabbed) {
        this.xmlComponent = comp;
        this.tabbed = tabbed;
        this.controller = Controller.instance(context.getSession());
        this.controller.addRequestListener(this.dispatcher);
        this.panels = tabbed.getElementsByTagName("xpanel");
        for (int i = 0; i < this.panels.getLength(); ++i) {
            Element panel = (Element)this.panels.item(i);
            TabbedPanelListener rl = new TabbedPanelListener(panel);
            String id = panel.getAttribute("id");
            this.dispatcher.addRequestListener(id, null, rl);
            String role = panel.getAttribute("role");
            if (role.length() > 0 && !context.isUserInRole(role)) {
                XoplonCtrl.setHidden(panel, true);
            }
            if (!"true".equals(panel.getAttribute("current"))) continue;
            this.currentPanel = panel;
        }
    }

    public void destroy(HttpSession session) {
        this.dispatcher.clear();
        this.controller.removeRequestListener(this.dispatcher);
        this.controller = null;
    }

    public void request(RequestContext context) throws Exception {
        this.dispatcher.request(context);
    }

    public void render(RequestContext context) throws Exception {
    }

    public void addPanelChangedListener(PanelChangeListener l) {
        this.panelChangeListeners.add(l);
    }

    public void removePanelChangedListener(PanelChangeListener l) {
        this.panelChangeListeners.remove(l);
    }

    protected void fireChanged(Element currentPanel) {
        if (this.panelChangeListeners.size() > 0) {
            PanelChangeEvent event = new PanelChangeEvent(this, currentPanel);
            List copy = (List)this.panelChangeListeners.clone();
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                ((PanelChangeListener)it.next()).panelChanged(event);
            }
        }
    }

    public void setCurrentPanel(RequestContext context, Element newCurrentPanel) {
        if (!this.xmlComponent.validate(context)) {
            return;
        }
        this.internalSetCurrent(newCurrentPanel);
        this.fireChanged(this.currentPanel);
        this.xmlComponent.revert(context);
    }

    private void internalSetCurrent(Element newCurrentPanel) {
        if (this.currentPanel != null) {
            DomUtils.removeAttribute(this.currentPanel, "current");
            this.currentPanel.setAttribute("children-hidden", "true");
        }
        this.currentPanel = newCurrentPanel;
        if (this.currentPanel != null) {
            this.currentPanel.setAttribute("current", "true");
            DomUtils.removeAttribute(this.currentPanel, "children-hidden");
            XoplonCtrl.setHidden(this.currentPanel, false);
        }
    }

    public void setHidden(RequestContext context, Element panel, boolean hidden) {
        String role = panel.getAttribute("role");
        if (!context.isUserInRole(role)) {
            return;
        }
        XoplonCtrl.setHidden(panel, hidden);
        if (hidden && panel.equals(this.currentPanel)) {
            this.internalSetCurrent(null);
            this.panels = this.tabbed.getElementsByTagName("xpanel");
            for (int i = 0; i < this.panels.getLength(); ++i) {
                Element e = (Element)this.panels.item(i);
                if (XoplonCtrl.isHidden(e)) continue;
                this.setCurrentPanel(context, e);
                break;
            }
        } else if (!hidden && this.currentPanel == null) {
            this.setCurrentPanel(context, panel);
        }
    }

    public NodeHandler getPanelHandler(String panelId) {
        return this.xmlComponent.getHandler(panelId);
    }

    class TabbedPanelListener
    implements RequestListener {
        private Element panel;

        TabbedPanelListener(Element panel) {
            this.panel = panel;
        }

        public void request(RequestContext context) throws Exception {
            TabbedHandler.this.setCurrentPanel(context, this.panel);
        }
    }
}

