/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.selection;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.selection.SelectionChangeListener;
import com.tonbeller.wcf.selection.SelectionChangeSupport;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.selection.Unselectable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractSelectionModel
implements SelectionModel {
    private int mode;
    private SelectionChangeSupport changeSupport;

    public abstract Set getSelection();

    public abstract void add(Object var1);

    public abstract void remove(Object var1);

    public abstract void clear();

    protected AbstractSelectionModel(int mode) {
        this.mode = mode;
        this.changeSupport = new SelectionChangeSupport(this);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean contains(Object obj) {
        return this.getSelection().contains(obj);
    }

    public Object getSingleSelection() {
        Set selection = this.getSelection();
        if (selection.size() == 0) {
            return null;
        }
        if (selection.size() == 1) {
            return selection.iterator().next();
        }
        throw new IllegalStateException("single selection contains " + selection.size() + " elements");
    }

    public void setSingleSelection(Object obj) {
        this.clear();
        this.add(obj);
    }

    public boolean isEmpty() {
        return this.getSelection().isEmpty();
    }

    public boolean isSelectable(Object item) {
        return !(item instanceof Unselectable);
    }

    public void fireSelectionChanged(RequestContext context) {
        this.changeSupport.fireSelectionChanged(context);
    }

    public void addSelectionListener(SelectionChangeListener l) {
        this.changeSupport.addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionChangeListener l) {
        this.changeSupport.removeSelectionListener(l);
    }
}

