/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.format;

import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.FormatHandlerSupport;
import java.text.DecimalFormat;
import java.text.ParsePosition;

public abstract class NumberHandler
extends FormatHandlerSupport {
    double minValue = Double.NaN;

    public String format(Object o, String userPattern) {
        if (o == null) {
            return "";
        }
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(this.getLocale());
        df.applyPattern(this.findPattern(userPattern));
        return df.format(o);
    }

    public Object parse(String s, String userPattern) throws FormatException {
        if (s == null) {
            throw new FormatException(this.getErrorMessage(""));
        }
        if ((s = s.trim()).length() == 0) {
            throw new FormatException(this.getErrorMessage(""));
        }
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(this.getLocale());
        df.applyPattern(this.findPattern(userPattern));
        ParsePosition pos = new ParsePosition(0);
        Number n = df.parse(s, pos);
        if (n == null || pos.getIndex() != s.length()) {
            throw new FormatException(this.getErrorMessage(s));
        }
        if (!Double.isNaN(this.minValue) && n.doubleValue() < this.minValue) {
            throw new FormatException(this.getErrorMessage(s));
        }
        return n;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }
}

