/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.core.util.ObjectInputStreamWithClassloader;
import org.teiid.core.util.ReflectionHelper;

public class ExceptionHolder
implements Externalizable {
    private Throwable exception;
    private boolean nested = false;

    public ExceptionHolder() {
    }

    public ExceptionHolder(Throwable exception) {
        this.exception = exception;
    }

    public ExceptionHolder(Throwable exception, boolean nested) {
        this.exception = exception;
        this.nested = nested;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        List classNames = ExternalizeUtil.readList((ObjectInput)in, String.class);
        String message = (String)in.readObject();
        StackTraceElement[] stackTrace = (StackTraceElement[])in.readObject();
        String code = (String)in.readObject();
        ExceptionHolder causeHolder = (ExceptionHolder)in.readObject();
        byte[] serializedException = (byte[])in.readObject();
        this.exception = this.readFromByteArray(serializedException);
        if (this.exception == null) {
            Throwable t = this.buildException(classNames, message, stackTrace, code);
            if (causeHolder != null) {
                t.initCause(causeHolder.exception);
            }
            this.exception = t;
            if (this.exception instanceof SQLException) {
                try {
                    int count = in.readInt();
                    for (int i = 0; i < count; ++i) {
                        ExceptionHolder next = (ExceptionHolder)in.readObject();
                        if (!(next.exception instanceof SQLException)) continue;
                        ((SQLException)this.exception).setNextException((SQLException)next.exception);
                    }
                }
                catch (EOFException e) {
                }
                catch (OptionalDataException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> clazz = this.exception.getClass(); clazz != null && clazz != Throwable.class && clazz != Exception.class; clazz = clazz.getSuperclass()) {
            classNames.add(clazz.getName());
        }
        ExternalizeUtil.writeList((ObjectOutput)out, classNames);
        out.writeObject(this.exception.getMessage());
        out.writeObject(this.exception.getStackTrace());
        if (this.exception instanceof TeiidException) {
            out.writeObject(((TeiidException)this.exception).getCode());
        } else {
            out.writeObject(null);
        }
        if (this.exception.getCause() != null && this.exception.getCause() != this.exception) {
            out.writeObject(new ExceptionHolder(this.exception.getCause(), true));
        } else {
            out.writeObject(null);
        }
        if (!this.nested) {
            out.writeObject(this.writeAsByteArray(this.exception));
        } else {
            out.writeObject(null);
        }
        if (this.exception instanceof SQLException) {
            SQLException next;
            SQLException se = (SQLException)this.exception;
            int count = 0;
            for (next = se.getNextException(); next != null; next = next.getNextException()) {
                ++count;
            }
            out.writeInt(count);
            for (next = se.getNextException(); next != null; next = next.getNextException()) {
                out.writeObject(new ExceptionHolder(next, true));
            }
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    private Throwable buildException(List<String> classNames, String message, StackTraceElement[] stackTrace, String code) {
        String originalClass = Exception.class.getName();
        if (!classNames.isEmpty()) {
            originalClass = classNames.get(0);
        }
        List<String> args = Arrays.asList(CorePlugin.Util.getString("ExceptionHolder.converted_exception", new Object[]{message, originalClass}));
        Throwable result = null;
        for (String className : classNames) {
            try {
                result = (Throwable)ReflectionHelper.create((String)className, args, (ClassLoader)ExceptionHolder.class.getClassLoader());
                break;
            }
            catch (TeiidException e1) {
            }
        }
        if (result == null) {
            result = new TeiidRuntimeException(args.get(0));
        } else if (result instanceof TeiidException) {
            ((TeiidException)result).setCode(code);
            ((TeiidException)result).setOriginalType(classNames.get(0));
        }
        result.setStackTrace(stackTrace);
        return result;
    }

    private byte[] writeAsByteArray(Throwable t) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(t);
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private Throwable readFromByteArray(byte[] contents) {
        if (contents != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(contents);
            try {
                ObjectInputStreamWithClassloader ois = new ObjectInputStreamWithClassloader((InputStream)bais, ExceptionHolder.class.getClassLoader());
                return (Throwable)ois.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<ExceptionHolder> toExceptionHolders(List<? extends Throwable> throwables) {
        ArrayList<ExceptionHolder> list = new ArrayList<ExceptionHolder>();
        for (Throwable throwable : throwables) {
            list.add(new ExceptionHolder(throwable));
        }
        return list;
    }

    public static List<Throwable> toThrowables(List<ExceptionHolder> exceptionHolders) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (ExceptionHolder e : exceptionHolders) {
            list.add(e.getException());
        }
        return list;
    }
}

