/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.UDFMetaData;
import org.teiid.metadata.index.IndexMetadataStore;

public final class TeiidAttachments {
    public static final AttachmentKey<VDBTranslatorMetaData> TRANSLATOR_METADATA = AttachmentKey.create(VDBTranslatorMetaData.class);
    public static final AttachmentKey<VDBMetaData> VDB_METADATA = AttachmentKey.create(VDBMetaData.class);
    public static final AttachmentKey<UDFMetaData> UDF_METADATA = AttachmentKey.create(UDFMetaData.class);
    public static final AttachmentKey<IndexMetadataStore> INDEX_METADATA = AttachmentKey.create(IndexMetadataStore.class);
    public static final AttachmentKey<DeploymentType> DEPLOYMENT_TYPE = AttachmentKey.create(DeploymentType.class);

    public static boolean isVDBDeployment(DeploymentUnit deploymentUnit) {
        return DeploymentType.VDB == deploymentUnit.getAttachment(DEPLOYMENT_TYPE) || DeploymentType.DYNAMIC_VDB == deploymentUnit.getAttachment(DEPLOYMENT_TYPE);
    }

    public static boolean isDynamicVDB(DeploymentUnit deploymentUnit) {
        return DeploymentType.DYNAMIC_VDB == deploymentUnit.getAttachment(DEPLOYMENT_TYPE);
    }

    public static void setAsVDBDeployment(DeploymentUnit deploymentUnit) {
        deploymentUnit.putAttachment(DEPLOYMENT_TYPE, (Object)DeploymentType.VDB);
    }

    public static void setAsDynamicVDBDeployment(DeploymentUnit deploymentUnit) {
        deploymentUnit.putAttachment(DEPLOYMENT_TYPE, (Object)DeploymentType.DYNAMIC_VDB);
    }

    public static void setAsTranslatorDeployment(DeploymentUnit deploymentUnit) {
        deploymentUnit.putAttachment(DEPLOYMENT_TYPE, (Object)DeploymentType.TRANSLATOR);
    }

    public static boolean isTranslator(DeploymentUnit deploymentUnit) {
        return DeploymentType.TRANSLATOR == deploymentUnit.getAttachment(DEPLOYMENT_TYPE);
    }

    static enum DeploymentType {
        VDB,
        DYNAMIC_VDB,
        TRANSLATOR;

    }
}

