/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.acls.sid.SidRetrievalStrategy;
import org.springframework.security.acls.sid.SidRetrievalStrategyImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class AccessControlListTag
extends TagSupport {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$taglibs$authz$AccessControlListTag == null ? (class$org$springframework$security$taglibs$authz$AccessControlListTag = AccessControlListTag.class$("org.springframework.security.taglibs.authz.AccessControlListTag")) : class$org$springframework$security$taglibs$authz$AccessControlListTag));
    private AclService aclService;
    private ApplicationContext applicationContext;
    private Object domainObject;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
    private SidRetrievalStrategy sidRetrievalStrategy;
    private String hasPermission = "";
    static /* synthetic */ Class class$org$springframework$security$taglibs$authz$AccessControlListTag;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$security$acls$AclService;
    static /* synthetic */ Class class$org$springframework$security$acls$sid$SidRetrievalStrategy;
    static /* synthetic */ Class class$org$springframework$security$acls$objectidentity$ObjectIdentityRetrievalStrategy;

    public int doStartTag() throws JspException {
        this.initializeIfRequired();
        if (null == this.hasPermission || "".equals(this.hasPermission)) {
            return 0;
        }
        String evaledPermissionsString = ExpressionEvaluationUtils.evaluateString((String)"hasPermission", (String)this.hasPermission, (PageContext)this.pageContext);
        Permission[] requiredPermissions = null;
        try {
            requiredPermissions = this.parsePermissionsString(evaledPermissionsString);
        }
        catch (NumberFormatException nfe) {
            throw new JspException((Throwable)nfe);
        }
        Object resolvedDomainObject = null;
        resolvedDomainObject = this.domainObject instanceof String ? ExpressionEvaluationUtils.evaluate((String)"domainObject", (String)((String)this.domainObject), (Class)(class$java$lang$Object == null ? (class$java$lang$Object = AccessControlListTag.class$("java.lang.Object")) : class$java$lang$Object), (PageContext)this.pageContext) : this.domainObject;
        if (resolvedDomainObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"domainObject resolved to null, so including tag body");
            }
            return 1;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SecurityContextHolder did not return a non-null Authentication object, so skipping tag body");
            }
            return 0;
        }
        Sid[] sids = this.sidRetrievalStrategy.getSids(SecurityContextHolder.getContext().getAuthentication());
        ObjectIdentity oid = this.objectIdentityRetrievalStrategy.getObjectIdentity(resolvedDomainObject);
        try {
            Acl acl = this.aclService.readAclById(oid, sids);
            if (acl.isGranted(requiredPermissions, sids, false)) {
                return 1;
            }
            return 0;
        }
        catch (NotFoundException nfe) {
            return 0;
        }
    }

    protected ApplicationContext getContext(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public Object getDomainObject() {
        return this.domainObject;
    }

    public String getHasPermission() {
        return this.hasPermission;
    }

    private void initializeIfRequired() throws JspException {
        if (this.applicationContext != null) {
            return;
        }
        this.applicationContext = this.getContext(this.pageContext);
        Map map = new HashMap();
        for (ApplicationContext context = this.applicationContext; context != null; context = context.getParent()) {
            map.putAll(context.getBeansOfType(class$org$springframework$security$acls$AclService == null ? AccessControlListTag.class$("org.springframework.security.acls.AclService") : class$org$springframework$security$acls$AclService));
        }
        if (map.size() != 1) {
            throw new JspException("Found incorrect number of AclService instances in application context - you must have only have one!");
        }
        this.aclService = (AclService)map.values().iterator().next();
        map = this.applicationContext.getBeansOfType(class$org$springframework$security$acls$sid$SidRetrievalStrategy == null ? (class$org$springframework$security$acls$sid$SidRetrievalStrategy = AccessControlListTag.class$("org.springframework.security.acls.sid.SidRetrievalStrategy")) : class$org$springframework$security$acls$sid$SidRetrievalStrategy);
        if (map.size() == 0) {
            this.sidRetrievalStrategy = new SidRetrievalStrategyImpl();
        } else if (map.size() == 1) {
            this.sidRetrievalStrategy = (SidRetrievalStrategy)map.values().iterator().next();
        } else {
            throw new JspException("Found incorrect number of SidRetrievalStrategy instances in application context - you must have only have one!");
        }
        map = this.applicationContext.getBeansOfType(class$org$springframework$security$acls$objectidentity$ObjectIdentityRetrievalStrategy == null ? (class$org$springframework$security$acls$objectidentity$ObjectIdentityRetrievalStrategy = AccessControlListTag.class$("org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategy")) : class$org$springframework$security$acls$objectidentity$ObjectIdentityRetrievalStrategy);
        if (map.size() == 0) {
            this.objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
        } else if (map.size() == 1) {
            this.objectIdentityRetrievalStrategy = (ObjectIdentityRetrievalStrategy)map.values().iterator().next();
        } else {
            throw new JspException("Found incorrect number of ObjectIdentityRetrievalStrategy instances in application context - you must have only have one!");
        }
    }

    private Permission[] parsePermissionsString(String integersString) throws NumberFormatException {
        HashSet<Permission> permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(integersString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String integer = tokenizer.nextToken();
            permissions.add(BasePermission.buildFromMask((int)new Integer(integer)));
        }
        return permissions.toArray(new Permission[permissions.size()]);
    }

    public void setDomainObject(Object domainObject) {
        this.domainObject = domainObject;
    }

    public void setHasPermission(String hasPermission) {
        this.hasPermission = hasPermission;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

