/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.OlapUnitImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.repository.RepositoryDataFilter;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.bookmarks.BookmarkManager;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.NodeHandlerSupport;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.ui.ListItem;
import com.tonbeller.wcf.ui.Select;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.AccessDeniedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Element;

public class RepoFolderList
extends NodeHandlerSupport
implements FormListener {
    private static Logger logger = Logger.getLogger(RepoFolderList.class);

    private void filterFolders(List folders, RepositoryDataFilter folderFilter) {
        HashSet<Folder> itemsToRemove = new HashSet<Folder>();
        for (Folder f : folders) {
            if (folderFilter.filter(f.getURIString())) continue;
            itemsToRemove.add(f);
        }
        if (itemsToRemove.size() > 0) {
            folders.removeAll(itemsToRemove);
        }
    }

    private RepositoryService getRepositoryServiceForAcl(ApplicationContext ctx) {
        RepositoryService repo = null;
        try {
            repo = (RepositoryService)ctx.getBean("mtRepositoryServiceForAclUpdate");
        }
        catch (Exception e) {
            repo = (RepositoryService)ctx.getBean("repositoryServiceForAclUpdate");
        }
        return repo;
    }

    private RepositoryService getRepositoryService(ApplicationContext ctx) {
        RepositoryService repository = null;
        try {
            repository = (RepositoryService)ctx.getBean("mtRepositoryService");
        }
        catch (NoSuchBeanDefinitionException e) {
            repository = (RepositoryService)ctx.getBean("repositoryService");
        }
        return repository;
    }

    public void populateFolderList(RequestContext context) {
        HttpSession session = context.getSession();
        HttpServletRequest request = context.getRequest();
        if (session == null || request == null) {
            return;
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getServletContext());
        RepositoryService repo = this.getRepositoryServiceForAcl((ApplicationContext)ctx);
        logger.debug((Object)"populateFolderList: getting repoService from repositoryServiceForAclUpdate");
        if (repo != null) {
            ArrayList folders = repo.getAllFolders(JasperServerUtil.getExecutionContext((HttpServletRequest)request));
            if (folders == null) {
                folders = new ArrayList();
            }
            try {
                RepositoryDataFilter folderFilter = (RepositoryDataFilter)ctx.getBean("jpivotRepositoryFilter");
                this.filterFolders(folders, folderFilter);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
            String selectedItem = "";
            Iterator iter = folders.iterator();
            Element list = this.getElement();
            Select.removeAllItems((Element)list);
            logger.debug((Object)"Adding folders for OLAP save as");
            while (iter.hasNext()) {
                list = this.getElement();
                String path = ((Folder)iter.next()).getURIString();
                if ((path + "/").startsWith("/adhoc/temp/")) continue;
                logger.debug((Object)("\t" + path));
                Element item = ListItem.addListItem((Element)list);
                ListItem.setId((Element)item, (String)path);
                ListItem.setValue((Element)item, (String)path);
                ListItem.setLabel((Element)item, (String)path);
                if (!"".equalsIgnoreCase(selectedItem)) continue;
                selectedItem = path;
            }
            if (folders.size() == 0) {
                Element item = ListItem.addListItem((Element)list);
                ListItem.setId((Element)item, (String)"");
                ListItem.setValue((Element)item, (String)"");
                ListItem.setLabel((Element)item, (String)"");
                selectedItem = "";
            }
            logger.debug((Object)("selected item: " + selectedItem));
            session.setAttribute("ja_saveas_selectedItem", (Object)selectedItem);
        }
    }

    public boolean validate(RequestContext context) {
        HttpSession sess = context.getRequest().getSession();
        HttpServletRequest request = context.getRequest();
        String name = context.getParameter("viewName");
        if (name == null || "".equals(name.trim())) {
            return true;
        }
        String errMsg = null;
        Resources resources = Resources.instance();
        String location = context.getParameter("location");
        if (location == null || "".equals(location.trim())) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.emptyFolderList", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("location", (Object)errMsg);
            return false;
        }
        String label = context.getParameter("viewName");
        if (label == null || label.trim().length() == 0) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.label.not.empty", null, resources.getLocaleContextHolderLocale());
        } else if (label.length() > 100) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.label.too.long", null, resources.getLocaleContextHolderLocale());
        } else if (!JasperServerUtil.regExValidateLabel((String)label)) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.label.invalid.chars", null, resources.getLocaleContextHolderLocale());
        }
        if (errMsg != null) {
            sess.setAttribute("viewName", (Object)errMsg);
            return false;
        }
        String description = context.getParameter("description");
        if (description != null && description.length() > 250) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.description.too.long", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("viewName", (Object)errMsg);
            return false;
        }
        OlapUnitImpl existingOlapUnit = (OlapUnitImpl)context.getRequest().getSession().getAttribute("olapUnit");
        if (existingOlapUnit == null) {
            throw new JSException("No OLAP Model retrieved");
        }
        ResourceReference olapCltConn = existingOlapUnit.getOlapClientConnection();
        Object state = BookmarkManager.instance((HttpSession)context.getRequest().getSession()).collectSessionState(0);
        OlapModel olapModel = (OlapModel)context.getSession().getAttribute("olapModel");
        Model mdl = ((OlapModelDecorator)olapModel).getRootModel();
        String drillThruSQL = null;
        String currentView = (String)context.getRequest().getSession().getAttribute("currentView");
        if (mdl instanceof MondrianModel) {
            try {
                EditableTableComponent et;
                if (currentView != null && (et = (EditableTableComponent)context.getRequest().getSession().getAttribute(currentView + ".drillthroughtable")) != null) {
                    drillThruSQL = ((MondrianDrillThroughTableModel)et.getModel()).getSql();
                    ((HashMap)state).put("drillThruSQL", drillThruSQL);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        OlapUnitImpl olapUnit = new OlapUnitImpl();
        String mdxQuery = null;
        if (mdl instanceof MondrianModel) {
            try {
                mdxQuery = ((MondrianModel)mdl).getCurrentMdx();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else if (mdl instanceof XMLA_Model) {
            mdxQuery = ((XMLA_Model)mdl).getCurrentMdx();
        }
        olapUnit.setMdxQuery(mdxQuery);
        olapUnit.setLabel(name);
        olapUnit.setDescription(description);
        olapUnit.setOlapClientConnection(olapCltConn);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getServletContext());
        RepositoryService repository = this.getRepositoryService((ApplicationContext)ctx);
        try {
            String curName = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)repository, (String)location, (String)name);
            olapUnit.setName(curName);
            olapUnit.setParentFolder(location);
            logger.debug((Object)("New olapUnit name " + curName + " in folder: " + location + ", full URI: " + olapUnit.getURIString()));
            HashMap pureState = new HashMap();
            this.removeNonCurrentViewBookmark(pureState, (HashMap)state, existingOlapUnit.getPath());
            HashMap newState = new HashMap();
            this.changeHashKeyToNewPath(newState, pureState, existingOlapUnit.getPath(), curName, location);
            olapUnit.setOlapViewOptions(newState);
            olapUnit.setVersion(-1);
            repository.saveResource(null, (Resource)olapUnit);
            olapUnit.setVersion(0);
            sess.setAttribute("olapUnit", (Object)olapUnit);
            sess.setAttribute("currentView", (Object)olapUnit.getURIString());
            this.revert(context);
            String fromPage = request.getHeader("Referer");
            fromPage = !fromPage.contains("?") ? fromPage + "?name=" : fromPage + "&name=";
            fromPage = fromPage + URLEncoder.encode(olapUnit.getURIString(), "UTF-8");
            logger.debug((Object)("Redirecting to: " + fromPage));
            context.getResponse().sendRedirect(fromPage);
        }
        catch (JSDuplicateResourceException e) {
            e.printStackTrace();
            return false;
        }
        catch (AccessDeniedException f) {
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.accessDenied", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("location", (Object)errMsg);
            logger.error((Object)f);
            return false;
        }
        catch (IOException g) {
            resources = Resources.instance();
            errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.needNewName", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("viewName", (Object)errMsg);
            logger.error((Object)g);
            return false;
        }
        return true;
    }

    private void changeHashKeyToNewPath(HashMap newState, HashMap existingState, String oldName, String newName, String parentFolder) {
        Set set = existingState.keySet();
        for (String key : set) {
            Object value = existingState.get(key);
            String newKey = key.replace(oldName, parentFolder + "/" + newName);
            newState.put(newKey, value);
        }
    }

    private void removeNonCurrentViewBookmark(HashMap pureState, HashMap state, String existingPathAndObject) {
        Set set = state.keySet();
        for (String key : set) {
            if ((!key.startsWith(existingPathAndObject) || key.length() <= existingPathAndObject.length() || key.charAt(existingPathAndObject.length()) != '.' && key.charAt(existingPathAndObject.length()) != '/') && !key.equals("drillThruSQL")) continue;
            Object value = state.get(key);
            pureState.put(key, value);
        }
    }

    public void initialize(RequestContext context, XmlComponent comp, Element element) throws Exception {
        super.initialize(context, comp, element);
        comp.addFormListener((FormListener)this);
        this.populateFolderList(context);
        this.revert(context);
    }

    public void revert(RequestContext context) {
        String curView;
        HttpSession sess = context.getRequest().getSession();
        FormComponent form = (FormComponent)sess.getAttribute((curView = (String)sess.getAttribute("currentView")) + "/saveas");
        if (form != null) {
            form.setError("location", null);
            form.setError("viewName", null);
            form.setError("description", null);
        }
    }
}

