/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.param;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.param.ParameterProvider;
import com.tonbeller.jpivot.param.SqlAccess;
import com.tonbeller.wcf.param.SessionParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultParamProvider
implements ParameterProvider {
    String paramName;
    String propertyName;
    String propertyPrefix;

    private DefaultParamProvider(String paramName, String propertyName, String propertyPrefix) {
        this.paramName = paramName;
        this.propertyName = propertyName;
        this.propertyPrefix = propertyPrefix;
    }

    public static ParameterProvider createMemberInstance(String paramName) {
        return new DefaultParamProvider(paramName, null, null);
    }

    public static ParameterProvider createPropertyInstance(String paramName, String propertyName) {
        return new DefaultParamProvider(paramName, propertyName, null);
    }

    public static ParameterProvider createPropertyPrefixInstance(String propertyPrefix) {
        return new DefaultParamProvider(null, null, propertyPrefix);
    }

    public List createSessionParams(OlapModel model, Member member) {
        SqlAccess sa = (SqlAccess)model.getExtension("sqlAccess");
        return this.createSessionParams(sa, member);
    }

    public List createSessionParams(SqlAccess sa, Member member) {
        if (sa == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SessionParam> result = new ArrayList<SessionParam>();
        if (this.paramName != null) {
            if (this.propertyName == null) {
                result.add(sa.createParameter(member, this.paramName));
            } else {
                result.add(sa.createParameter(member, this.paramName, this.propertyName));
            }
        } else if (this.propertyPrefix != null) {
            int prefixLength = this.propertyPrefix.length();
            Property[] p = member.getProperties();
            for (int i = 0; i < p.length; ++i) {
                String propertyName = p[i].getName();
                if (!propertyName.startsWith(this.propertyPrefix)) continue;
                String paramName = propertyName.substring(prefixLength);
                SessionParam sp = sa.createParameter(member, paramName, propertyName);
                result.add(sp);
            }
        } else {
            throw new IllegalArgumentException("either paramName or propertyPrefix must be present");
        }
        return result;
    }
}

