/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model.impl;

import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.FunCallExpr;
import com.tonbeller.jpivot.olap.model.PropertyExpr;
import com.tonbeller.jpivot.olap.model.StringExpr;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.model.VisitorSupportSloppy;
import java.util.ArrayList;

public class PropertyExprImpl
implements PropertyExpr {
    private Expression valueExpr;
    private String name;

    public PropertyExprImpl(String name, Expression valueExpr) {
        this.name = name;
        this.valueExpr = valueExpr;
    }

    public Expression getValueExpr() {
        return this.valueExpr;
    }

    public String getName() {
        return this.name;
    }

    public String[] getChoices() {
        final ArrayList choices = new ArrayList();
        this.accept(new VisitorSupportSloppy(){

            public void visitStringExpr(StringExpr v) {
                choices.add(v.getValue());
            }

            public void visitFunCallExpr(FunCallExpr v) {
                Expression[] args = v.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    args[i].accept(this);
                }
            }

            public void visitPropertyExpr(PropertyExpr v) {
                Expression exp = v.getValueExpr();
                exp.accept(this);
            }
        });
        return choices.toArray(new String[0]);
    }

    public void accept(Visitor visitor) {
        visitor.visitPropertyExpr(this);
    }
}

