/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian.script;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.script.ScriptableMondrianDrillThroughTableModel;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.wcf.table.TableModel;
import mondrian.olap.Connection;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;

public class ScriptableMondrianDrillThrough
extends ExtensionSupport
implements DrillThrough {
    private boolean extendedContext = true;

    public ScriptableMondrianDrillThrough() {
        super.setId("drillThrough");
    }

    public boolean canDrillThrough(Cell cell) {
        return ((MondrianCell)cell).getMonCell().canDrillThrough();
    }

    public TableModel drillThrough(Cell cell) {
        String sql = ((MondrianCell)cell).getMonCell().getDrillThroughSQL(this.extendedContext);
        if (sql == null) {
            throw new NullPointerException("DrillThroughSQL returned null");
        }
        ScriptableMondrianDrillThroughTableModel dtm = new ScriptableMondrianDrillThroughTableModel();
        dtm.setSql(sql);
        String connectString = this.getConnection().getConnectString();
        Util.PropertyList connectInfo = Util.parseConnectString((String)connectString);
        String jdbcUrl = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        dtm.setJdbcUrl(jdbcUrl);
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        dtm.setJdbcUser(jdbcUser);
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        dtm.setJdbcPassword(jdbcPassword);
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        dtm.setDataSourceName(dataSourceName);
        String catalog = connectInfo.get(RolapConnectionProperties.Catalog.name());
        String catalogExtension = catalog.replaceFirst(".*/", "").replaceFirst("\\.xml$", ".ext.xml");
        dtm.setCatalogExtension(catalogExtension);
        return dtm;
    }

    public Connection getConnection() {
        MondrianModel model = (MondrianModel)this.getModel();
        return model.getConnection();
    }

    public boolean isExtendedContext() {
        return this.extendedContext;
    }

    public void setExtendedContext(boolean extendedContext) {
        this.extendedContext = extendedContext;
    }
}

