/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.netezza;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Limit;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.ExtractFunctionModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.LocateFunctionModifier;

@Translator(name="netezza", description="A translator for Netezza Database")
public class NetezzaExecutionFactory
extends JDBCExecutionFactory {
    private static final String TIME_FORMAT = "HH24:MI:SS";
    private static final String DATE_FORMAT = "YYYY-MM-DD";
    private static final String DATETIME_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.MS";

    public NetezzaExecutionFactory() {
        this.setSupportsFullOuterJoins(true);
        this.setSupportsOrderBy(true);
        this.setSupportsOuterJoins(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportsInnerJoins(true);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("char", new AliasModifier("chr"));
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory(), "INSTR", true));
        this.registerFunctionModifier("concat", new AliasModifier("||"));
        this.registerFunctionModifier("ceiling", new AliasModifier("ceil"));
        this.registerFunctionModifier("power", new AliasModifier("pow"));
        this.registerFunctionModifier("log", new AliasModifier("LN"));
        this.registerFunctionModifier("bitand", new AliasModifier("int4and"));
        this.registerFunctionModifier("bitnot", new AliasModifier("int4not"));
        this.registerFunctionModifier("bitor", new AliasModifier("int4or"));
        this.registerFunctionModifier("bitxor", new AliasModifier("int4xor"));
        this.registerFunctionModifier("year", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofyear", new ExtractModifier("DOY"));
        this.registerFunctionModifier("quarter", new ExtractFunctionModifier());
        this.registerFunctionModifier("month", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofmonth", new ExtractModifier("DAY"));
        this.registerFunctionModifier("week", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofweek", new ExtractModifier("DOW"));
        this.registerFunctionModifier("hour", new ExtractFunctionModifier());
        this.registerFunctionModifier("minute", new ExtractFunctionModifier());
        this.registerFunctionModifier("second", new ExtractFunctionModifier());
        this.registerFunctionModifier("curdate", new AliasModifier("CURRENT_DATE"));
        this.registerFunctionModifier("curtime", new AliasModifier("CURRENT_TIME"));
        this.registerFunctionModifier("ifnull", new AliasModifier("NVL"));
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("byteint", 3);
        convertModifier.addTypeMapping("smallint", 4);
        convertModifier.addTypeMapping("bigint", 6);
        convertModifier.addTypeMapping("numeric(38)", 7);
        convertModifier.addTypeMapping("numeric(38,18)", 10);
        convertModifier.addTypeMapping("varchar(4000)", 0);
        convertModifier.addConvert(2, 5, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 3, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 4, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 6, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 8, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 9, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 7, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 10, new BooleanToNumericConversionModifier());
        convertModifier.addConvert(2, 0, new BooleanToStringConversionModifier());
        convertModifier.addConvert(0, 2, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " IN ('false', '0') THEN '0' WHEN ", stringValue, " IS NOT NULL THEN '1' END");
            }
        });
        convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " = 0 THEN '0' WHEN ", stringValue, " IS NOT NULL THEN '1' END");
            }
        }, 2);
        convertModifier.addConvert(0, 5, new CastModifier("integer"));
        convertModifier.addConvert(0, 8, new CastModifier("float"));
        convertModifier.addConvert(0, 9, new CastModifier("double"));
        convertModifier.addConvert(0, 11, new ConvertModifier.FormatModifier("to_date", DATE_FORMAT));
        convertModifier.addConvert(0, 12, new ConvertModifier.FormatModifier("to_timestamp", TIME_FORMAT));
        convertModifier.addConvert(0, 13, new ConvertModifier.FormatModifier("to_timestamp", TIMESTAMP_FORMAT));
        convertModifier.addConvert(13, 12, new CastModifier("TIME"));
        convertModifier.addConvert(13, 11, new CastModifier("DATE"));
        convertModifier.addConvert(11, 13, new CastModifier("TIMESTAMP"));
        convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("to_char", TIMESTAMP_FORMAT));
        convertModifier.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", convertModifier);
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("initcap");
        supportedFunctions.add("lcase");
        supportedFunctions.add("lpad");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("ucase");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("degrees");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("nullif");
        supportedFunctions.add("convert");
        return supportedFunctions;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return null;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public static class CastModifier
    extends FunctionModifier {
        private String target;

        public CastModifier(String target) {
            this.target = target;
        }

        @Override
        public List<?> translate(Function function) {
            return Arrays.asList("cast(", function.getParameters().get(0), " AS " + this.target + ")");
        }
    }

    public static class BooleanToStringConversionModifier
    extends FunctionModifier {
        @Override
        public List<?> translate(Function function) {
            Function nested;
            Expression booleanValue = (Expression)function.getParameters().get(0);
            if (booleanValue instanceof Function && (nested = (Function)booleanValue).getName().equalsIgnoreCase("convert") && Number.class.isAssignableFrom(((Expression)nested.getParameters().get(0)).getType())) {
                booleanValue = (Expression)nested.getParameters().get(0);
            }
            return Arrays.asList("CASE WHEN ", booleanValue, " = '0' THEN 'false' WHEN ", booleanValue, " IS NOT NULL THEN 'true' END");
        }
    }

    public static class BooleanToNumericConversionModifier
    extends FunctionModifier {
        @Override
        public List<?> translate(Function function) {
            Function nested;
            Expression booleanValue = (Expression)function.getParameters().get(0);
            if (booleanValue instanceof Function && (nested = (Function)booleanValue).getName().equalsIgnoreCase("convert") && Number.class.isAssignableFrom(((Expression)nested.getParameters().get(0)).getType())) {
                booleanValue = (Expression)nested.getParameters().get(0);
            }
            return Arrays.asList("(CASE WHEN ", booleanValue, " IN ( '0', 'FALSE') THEN 0 WHEN ", booleanValue, " IS NOT NULL THEN 1 END)");
        }
    }

    public static class ExtractModifier
    extends FunctionModifier {
        private String type;

        public ExtractModifier(String type) {
            this.type = type;
        }

        @Override
        public List<?> translate(Function function) {
            return Arrays.asList("extract(", this.type, " from ", function.getParameters().get(0), ")");
        }
    }
}

