/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.mysql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.mysql.BitFunctionModifier;

@Translator(name="mysql", description="A translator for open source MySQL Database, used with any version lower than 5")
public class MySQLExecutionFactory
extends JDBCExecutionFactory {
    public MySQLExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("bitand", new BitFunctionModifier("&", this.getLanguageFactory()));
        this.registerFunctionModifier("bitnot", new BitFunctionModifier("~", this.getLanguageFactory()));
        this.registerFunctionModifier("bitor", new BitFunctionModifier("|", this.getLanguageFactory()));
        this.registerFunctionModifier("bitxor", new BitFunctionModifier("^", this.getLanguageFactory()));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("lpad", new PadFunctionModifier());
        this.registerFunctionModifier("rpad", new PadFunctionModifier());
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("signed", 2, 3, 4, 5, 6);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("char", 0);
        convertModifier.addTypeMapping("date", 11);
        convertModifier.addTypeMapping("time", 12);
        convertModifier.addTypeMapping("datetime", 13);
        convertModifier.addConvert(0, 11, new ConvertModifier.FormatModifier("DATE"));
        convertModifier.addConvert(0, 12, new ConvertModifier.FormatModifier("TIME"));
        convertModifier.addConvert(0, 13, new ConvertModifier.FormatModifier("TIMESTAMP"));
        convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("date_format", "%Y-%m-%d"));
        convertModifier.addConvert(12, 0, new ConvertModifier.FormatModifier("date_format", "%H:%i:%S"));
        convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("date_format", "%Y-%m-%d %H:%i:%S.%f"));
        convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), " + 0.0");
            }
        }, 10, 7, 8, 9);
        convertModifier.addNumericBooleanConversions();
        convertModifier.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", convertModifier);
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE('" + this.formatDateValue(dateValue) + "')";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME('" + this.formatDateValue(timeValue) + "')";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts '" + this.formatDateValue(timestampValue) + "'}";
    }

    @Override
    public boolean useParensForSetQueries() {
        return true;
    }

    @Override
    public int getTimestampNanoPrecision() {
        return 0;
    }

    @Override
    public boolean useParensForJoins() {
        return true;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("degrees");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("insert");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("convert");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("coalesce");
        return supportedFunctions;
    }

    @Override
    public boolean supportsAggregatesDistinct() {
        return false;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    private final class PadFunctionModifier
    extends FunctionModifier {
        private PadFunctionModifier() {
        }

        @Override
        public List<?> translate(Function function) {
            if (function.getParameters().size() == 2) {
                function.getParameters().add(MySQLExecutionFactory.this.getLanguageFactory().createLiteral((Object)" ", TypeFacility.RUNTIME_TYPES.STRING));
            }
            return null;
        }
    }
}

