/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MessageLevel {
    public static final int NONE = 0;
    public static final int CRITICAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int INFO = 4;
    public static final int DETAIL = 5;
    public static final int TRACE = 6;
    public static final int DEFAULT_MESSAGE_LEVEL = 3;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 6;
    private static Map LABEL_TO_LEVEL_MAP = new HashMap();
    private static Map DISPLAY_TO_LEVEL_MAP = new HashMap();
    private static List LABELS = new ArrayList(7);
    private static List DISPLAYS = new ArrayList(7);

    public static boolean isMessageLevelValid(int newMessageLevel) {
        return newMessageLevel >= 0 && newMessageLevel <= 6;
    }

    public static int getValidLowerMessageLevel() {
        return 0;
    }

    public static int getValidUpperMessageLevel() {
        return 6;
    }

    public static String getLabelForLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "CRITICAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARNING";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "DETAIL";
            }
            case 6: {
                return "TRACE";
            }
        }
        return "UNKNOWN";
    }

    public static int getMinimumLevel() {
        return 0;
    }

    public static int getMaximumLevel() {
        return 6;
    }

    public static Collection getDisplayNames() {
        return DISPLAYS;
    }

    public static List getLabels() {
        return LABELS;
    }

    static {
        LABEL_TO_LEVEL_MAP.put("CRITICAL", new Integer(1));
        LABEL_TO_LEVEL_MAP.put("ERROR", new Integer(2));
        LABEL_TO_LEVEL_MAP.put("WARNING", new Integer(3));
        LABEL_TO_LEVEL_MAP.put("INFO", new Integer(4));
        LABEL_TO_LEVEL_MAP.put("DETAIL", new Integer(5));
        LABEL_TO_LEVEL_MAP.put("TRACE", new Integer(6));
        LABEL_TO_LEVEL_MAP.put("NONE", new Integer(0));
        DISPLAY_TO_LEVEL_MAP.put("Critical", new Integer(1));
        DISPLAY_TO_LEVEL_MAP.put("Error", new Integer(2));
        DISPLAY_TO_LEVEL_MAP.put("Warning", new Integer(3));
        DISPLAY_TO_LEVEL_MAP.put("Information", new Integer(4));
        DISPLAY_TO_LEVEL_MAP.put("Detail", new Integer(5));
        DISPLAY_TO_LEVEL_MAP.put("Trace", new Integer(6));
        DISPLAY_TO_LEVEL_MAP.put("None", new Integer(0));
        LABELS.add("NONE");
        LABELS.add("CRITICAL");
        LABELS.add("ERROR");
        LABELS.add("WARNING");
        LABELS.add("INFO");
        LABELS.add("DETAIL");
        LABELS.add("TRACE");
        DISPLAYS.add("None");
        DISPLAYS.add("Critical");
        DISPLAYS.add("Error");
        DISPLAYS.add("Warning");
        DISPLAYS.add("Information");
        DISPLAYS.add("Detail");
        DISPLAYS.add("Trace");
    }

    public static class DisplayNames {
        public static final String CRITICAL = "Critical";
        public static final String ERROR = "Error";
        public static final String WARNING = "Warning";
        public static final String INFO = "Information";
        public static final String DETAIL = "Detail";
        public static final String TRACE = "Trace";
        public static final String NONE = "None";
    }

    public static class Labels {
        public static final String CRITICAL = "CRITICAL";
        public static final String ERROR = "ERROR";
        public static final String WARNING = "WARNING";
        public static final String INFO = "INFO";
        public static final String DETAIL = "DETAIL";
        public static final String TRACE = "TRACE";
        public static final String NONE = "NONE";
        static final String UNKNOWN = "UNKNOWN";
    }
}

