/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.spring.AbstractBeanPropertyProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyListAppender
extends AbstractBeanPropertyProcessor {
    private static final Log log = LogFactory.getLog(BeanPropertyListAppender.class);
    private Object appended;
    private int index = -1;

    @Override
    protected Object getProcessedPropertyValue(Object originalValue) {
        List<Object> newValue;
        if (originalValue == null) {
            newValue = new ArrayList();
        } else {
            if (!(originalValue instanceof List)) {
                throw new JSException("jsexception.property.not.a.list", new Object[]{this.getPropertyName(), this.getBeanName()});
            }
            newValue = (List)originalValue;
        }
        if (this.appended instanceof List) {
            List appendedList = (List)this.appended;
            if (this.index >= 0) {
                newValue.addAll(this.index, appendedList);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Inserting " + appendedList.size() + " entries at index " + this.index + " into " + this.getBeanName() + "." + this.getPropertyName()));
                }
            } else {
                newValue.addAll(appendedList);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Adding " + appendedList.size() + " entries to " + this.getBeanName() + "." + this.getPropertyName()));
                }
            }
        } else if (this.index >= 0) {
            newValue.add(this.index, this.appended);
            if (log.isInfoEnabled()) {
                log.info((Object)("Inserting 1 entry at index " + this.index + " into " + this.getBeanName() + "." + this.getPropertyName()));
            }
        } else {
            newValue.add(this.appended);
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding 1 entry to " + this.getBeanName() + "." + this.getPropertyName()));
            }
        }
        return newValue;
    }

    public Object getAppended() {
        return this.appended;
    }

    public void setAppended(Object appended) {
        this.appended = appended;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

