/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.service.ObjectFactory;
import com.jaspersoft.jasperserver.api.common.service.impl.BaseClassMappings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectFactoryImpl
extends BaseClassMappings
implements ObjectFactory,
Serializable {
    private static final Log log = LogFactory.getLog(ObjectFactoryImpl.class);

    public Object newObject(Map classMappings, Class _class) {
        Class implementationClass = this.getImplementationClass(classMappings, _class);
        if (implementationClass == null) {
            throw new JSException("jsexception.implementation.class.not.found", new Object[]{_class.getName()});
        }
        try {
            return implementationClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public Class getImplementationClass(Map classMappings, Class itfClass) {
        String implName = (String)this.getClassMapping(classMappings, itfClass);
        Class<?> implClass = null;
        if (implName != null) {
            try {
                implClass = Class.forName(implName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
        }
        return implClass;
    }

    public String getImplementationClassName(Map classMappings, Class itfClass) {
        Class _class = this.getImplementationClass(classMappings, itfClass);
        if (_class == null) {
            return null;
        }
        return _class.getName();
    }

    public Class getInterface(Map classMappings, Class implClass) {
        if (classMappings == null) {
            return null;
        }
        try {
            Class<?> interfaceClass = null;
            for (Map.Entry entry : classMappings.entrySet()) {
                String itfName = (String)entry.getKey();
                String implName = (String)entry.getValue();
                Class<?> itf = Class.forName(itfName, true, Thread.currentThread().getContextClassLoader());
                if (!implClass.getName().startsWith(implName, 0)) continue;
                interfaceClass = itf;
                break;
            }
            return interfaceClass;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public String getInterfaceName(Map classMappings, Class implClass) {
        Class _class = this.getInterface(classMappings, implClass);
        if (_class == null) {
            return null;
        }
        return _class.getName();
    }

    public Class getImplementationClass(Map classMappings, String id) {
        if (classMappings == null) {
            return null;
        }
        try {
            String implName = (String)classMappings.get(id);
            Class<?> implClass = Class.forName(implName, true, Thread.currentThread().getContextClassLoader());
            return implClass;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public String getImplementationClassName(Map classMappings, String id) {
        return (String)classMappings.get(id);
    }

    public String getIdForClass(Map classMappings, Class _class) {
        if (classMappings == null) {
            return null;
        }
        for (Map.Entry entry : classMappings.entrySet()) {
            String id = (String)entry.getKey();
            String implName = (String)entry.getValue();
            if (!_class.getName().startsWith(implName, 0)) continue;
            return id;
        }
        return null;
    }

    public Object newObject(Map classMappings, String id) {
        Class implementationClass = this.getImplementationClass(classMappings, id);
        if (implementationClass == null) {
            throw new JSException("jsexception.implementation.class.not.found", new Object[]{id});
        }
        try {
            return implementationClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public List getKeys(Map classMappings) {
        ArrayList l = new ArrayList(classMappings.keySet());
        Collections.sort(l);
        return l;
    }
}

