/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLATestResult {
    protected XMLATestCode status;
    protected String message;
    protected String details;
    protected String[] options;
    protected static final String regexUri = "(.*//.*:).*(@.*)";
    protected static final Set<XMLATestCode> ioExceptionTestCodes = new HashSet<XMLATestCode>(Arrays.asList(XMLATestCode.URI_CONNECTION_FAILED, XMLATestCode.BAD_URI, XMLATestCode.BAD_CREDENTIALS));

    public XMLATestResult(XMLATestCode status, String message, String[] options, Exception e) {
        this.status = status;
        this.options = options;
        if (e != null) {
            Matcher m = Pattern.compile(regexUri).matcher(message);
            boolean obfuscatePassword = ioExceptionTestCodes.contains((Object)status) && m.matches();
            this.message = obfuscatePassword ? m.replaceFirst("$1********$2") : message;
            StringWriter result = new StringWriter();
            PrintWriter trace = new PrintWriter(result);
            e.printStackTrace(trace);
            this.details = result.toString();
        }
    }

    public XMLATestResult(XMLATestCode status, String message, Exception e) {
        this(status, message, null, e);
    }

    public XMLATestResult(XMLATestCode status) {
        this(status, "", null, null);
    }

    public String buildJson() throws Exception {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", this.status.name());
        response.put("message", this.message);
        if (this.details != null) {
            response.put("details", this.details);
        }
        ObjectMapper mapper = new ObjectMapper();
        StringWriter result = new StringWriter();
        mapper.writeValue((Writer)result, response);
        return result.toString();
    }

    public XMLATestCode getStatus() {
        return this.status;
    }

    public void setStatus(XMLATestCode status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public static enum XMLATestCode {
        OK,
        URI_CONNECTION_FAILED,
        BAD_URI,
        BAD_CREDENTIALS,
        BAD_DATASOURCE,
        BAD_CATALOG,
        OTHER;

    }
}

